VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   6000
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   9930
   LinkTopic       =   "Form1"
   ScaleHeight     =   6000
   ScaleWidth      =   9930
   StartUpPosition =   3  'Windows Default
   Begin VB.ListBox List1 
      Height          =   1425
      Left            =   120
      TabIndex        =   5
      Top             =   4440
      Width           =   2655
   End
   Begin VB.PictureBox PicContenedor 
      Height          =   5775
      Left            =   2880
      ScaleHeight     =   5715
      ScaleWidth      =   6915
      TabIndex        =   3
      Top             =   120
      Width           =   6975
      Begin VB.PictureBox PicImagen 
         Height          =   2055
         Left            =   120
         ScaleHeight     =   1995
         ScaleWidth      =   1995
         TabIndex        =   4
         Top             =   480
         Width           =   2055
      End
   End
   Begin VB.FileListBox File1 
      Height          =   2625
      Left            =   120
      TabIndex        =   2
      Top             =   1800
      Width           =   2655
   End
   Begin VB.DirListBox Dir1 
      Height          =   1215
      Left            =   120
      TabIndex        =   1
      Top             =   480
      Width           =   2655
   End
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2655
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
 ' Declaracin de funciones Api para copiar la imagen a escala en el picturebox
  '*******************************************************************************
Private Declare Function StretchBlt Lib "gdi32" (ByVal hdc As Long, _
                         ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, _
                         ByVal nHeight As Long, ByVal hSrcDC As Long, _
                         ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth _
                         As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) _
                         As Long
Private Declare Function SetStretchBltMode Lib "gdi32" (ByVal hdc As Long, _
                         ByVal nStretchMode As Long) As Long
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal _
                         hObject As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long

'********************************************************************************


Private Sub File1_Click()
    
    ' Variable para el tipo de animacin ( AnimateWindowFlags )
    Dim flags As AnimateWindowFlags
    
    ' Selecciona el tipo de animacin elegida y la asigna a _
     la variable flags que luego se pasa a la funcin " Animar "
    Select Case List1.Text
        
        Case "Centro": flags = AW_CENTER
        Case "Top Bottom": flags = AW_VER_POSITIVE
        Case "Bottom - Top": flags = AW_VER_NEGATIVE
        Case "Left - Right": flags = AW_HOR_POSITIVE
        Case "Right - Left": flags = AW_HOR_NEGATIVE
        Case "Diagonal 1": flags = AW_HOR_POSITIVE Or AW_VER_POSITIVE
        Case "Diagonal 2": flags = AW_HOR_NEGATIVE Or AW_VER_NEGATIVE
        Case "Diagonal 3": flags = AW_VER_POSITIVE Or AW_HOR_NEGATIVE
        Case "Diagonal 4": flags = AW_VER_NEGATIVE Or AW_HOR_POSITIVE
        
    End Select
    
    ' Animacin del PicImagen ( Lo oculta )
    Call Animar(PicImagen, 250, flags Or AW_HIDE)
    PicImagen.Picture = Nothing ' Limpia la imagen
    'Carga la nueva imagen elegida y la dibuja
    ScaleImage LoadPicture(Dir1.Path & "\" & File1.FileName), PicImagen
    ' Convierte la imagen a un mapa de bits
    Set PicImagen.Picture = PicImagen.Image
    ' Animacin de la imagen ( la muestra )
    Animar PicImagen, 350, flags Or AW_ACTIVATE
    'Limpia
    PicImagen.Cls
End Sub

Private Sub Form_Load()

    File1.Pattern = "*.bmp;*.gif;*.jpg;*.jpeg"

    ' Posiciona el PicImagen en el picture contenedor
    PicImagen.Move 0, 0, PicContenedor.ScaleWidth, _
                        PicContenedor.ScaleHeight
    
    Dir1.Path = "c:\"
    
    ' Propiedades del picture que muestra la imagen y para el contenedor
    With PicImagen
        .AutoRedraw = True
        .BackColor = vbBlack
        .BorderStyle = 0
         Set .Picture = .Image
         PicContenedor.BackColor = vbBlack
         .ForeColor = vbGreen
         .FontSize = 10
         .FontBold = True
         PicImagen.Print " Selecciona una imagen y especifica el estilo de animacin "
    End With
    
    ' cargar en el listbox los Diferentes Tipos de animacin
    With List1
        .AddItem "Centro"
        .AddItem "Top Bottom"
        .AddItem "Bottom - Top"
        .AddItem "Left - Right"
        .AddItem "Right - Left"
        .AddItem "Diagonal 1"
        .AddItem "Diagonal 2"
        .AddItem "Diagonal 3"
        .AddItem "Diagonal 4"
        List1.ListIndex = 0
    End With
    
    
    On Error Resume Next
    Drive1 = "c:\"
    Dir1.Path = "c:\windows\web\wallpaper"
    Me.Caption = "Ejemplo de animacin de ventanas y controles "
    
    
End Sub

'Funcin que dibuja el archivo grafico seleccionado, en el control PicImagen
Public Function ScaleImage(Img As StdPicture, Pic As Object)

    Dim PLeft As Long, PTop As Long
    Dim ReqWidth As Long, ReqHeight As Long
    Dim HScale As Double, VScale As Double
    Dim MyScale As Double
    Dim ImgWidth As Long
    Dim ImgHeight As Long
    Dim SourceHDC As Long

    'Escala en pixles y Autoredraw para el Picturebox
    Pic.ScaleMode = vbPixels
    Pic.AutoRedraw = True

    'Limpia la imagen
    
    ' Convierte el valor de Himetric a pixeles
    ImgWidth = Me.ScaleX(Img.Width, vbHimetric, vbPixels)
    ImgHeight = Me.ScaleY(Img.Height, vbHimetric, vbPixels)
    
    ' Escala horizontal y vertical
    HScale = Pic.ScaleWidth / ImgWidth
    VScale = Pic.ScaleHeight / ImgHeight

    MyScale = IIf(VScale >= HScale, HScale, VScale)
    
    ReqWidth = ImgWidth * MyScale
    ReqHeight = ImgHeight * MyScale
    
    'Posicin izquierda y Arriba, para centra el grfico: valores x y
    PLeft = (Pic.ScaleWidth - ReqWidth) / 2
    PTop = (Pic.ScaleHeight - ReqHeight) / 2
      
    SourceHDC = CreateCompatibleDC(0)
    DeleteObject SelectObject(SourceHDC, Img.Handle)


    SetStretchBltMode Pic.hdc, vbPaletteModeNone

    ' Si es un cono usa PaintPicture, si no StretchBlt
    If Img.Type = 3 Then
        Pic.PaintPicture Img, PLeft, PTop, ReqWidth, ReqHeight
    Else
    'Copia el grfico en el PictureBox
        StretchBlt Pic.hdc, PLeft, PTop, ReqWidth, ReqHeight, _
                  SourceHDC, 0, 0, ImgWidth, ImgHeight, vbSrcCopy
   
    'Libera el dispositivo
    DeleteDC SourceHDC

End If

End Function


Private Sub Dir1_Change()
    File1 = Dir1
End Sub

Private Sub Drive1_Change()
    Dir1 = Drive1
End Sub
 

