VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsHScrollValue"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' -----------------------------------------------------------------------------------------------------------
' -- Descripcin: Simple mdulo para mostrar un tip/Text al mover una barra de desplazamiento horizontal de vb utilizando un label
' -- Autor original del ejemplo ( funcin pvShowValue -- Desconocido -- Creo que el ejemplo es del sitio web www.a1vbcode.com )
' -- Adaptado para usarlo en un mdulo de clase para poder implementarlo con varios scroll: ( Luciano Lodola -- http://www.recursosvisualbasic.com.ar/)
' -- Derechos : Este ejemplo no contiene limitaciones de uso:
'               Se puede utilizar, modificar y distribuir sin ningn tipo de restriccin.
'               En caso de publicar en un sitio o utilizarlo en un programa, se agradece mensionar y mantener el nombre de los autores del mismo


' -----------------------------------------------------------------------------------------------------------

' -- Importante: Solo implementado para utilizarlo con Scrolls horizontales,
'                ( Falta el cdigo para adaptarlo con Barras verticales, y algunas propiedades y eventos bsicos )
' --------------------------------------------------------------------------------

' --------------------------------------------------------------------------------
' \\ -- Declaraciones
' --------------------------------------------------------------------------------

Private Type TOpciones
    lBorderStyle                   As Integer
    HideLostFocus                  As Boolean
End Type

' -- Variables
Private x                          As Double
Private y                          As Double
Private WithEvents mHSBar          As hScrollBar                ' -- Declaracin de controles
Attribute mHSBar.VB_VarHelpID = -1
Private WithEvents mVS             As VScrollBar
Attribute mVS.VB_VarHelpID = -1
Private WithEvents mPicContainer   As PictureBox
Attribute mPicContainer.VB_VarHelpID = -1
Private WithEvents mText           As Label
Attribute mText.VB_VarHelpID = -1
Private WithEvents mOwnerForm      As Form
Attribute mOwnerForm.VB_VarHelpID = -1
Private mNameContainer             As String                    ' -- Nombres para poder descargarlos
Private mNameLabel                 As String
Private OptionLabel                As TOpciones                 ' -- Opciones del texto del label
Private bInitActivateFlag          As Boolean
Private mDefaultValue              As Integer                   ' -- Valor por defecto de las barras

' -- Eventos
Event ChangeValue(ByVal iValue As Integer)

' --------------------------------------------------------------------------------
' \\ -- Fin del mdulo
' --------------------------------------------------------------------------------
Private Sub Class_Terminate()
    'On Error Resume Next
    With mOwnerForm
        If Not mOwnerForm Is Nothing Then
            Set mHSBar.Container = mOwnerForm
            Call .Controls.Remove(mNameLabel)
            Call .Controls.Remove(mNameContainer)
        End If
    End With
    'On Error GoTo 0
End Sub
' --------------------------------------------------------------------------------
' \\ -- Inicio del mdulo
' --------------------------------------------------------------------------------
Sub Init( _
    hScrollBar As hScrollBar, _
    OwnerForm As Form, _
    MinValue As Integer, _
    MaxValue As Integer, _
    iValue As Integer, _
    Optional iLargeChange As Integer = 1, _
    Optional iSmallChange As Integer = 1, _
    Optional HideLostFocus As Boolean = False, _
    Optional ShowBorderStyle As Boolean = False, _
    Optional lForeColorText As Long)
    
    
    On Error GoTo Error_Handler
    
    ' -- Variables
    Dim mParent As Object
    
    ' --- Referenciar controles para poder usarlos internemente
    '     dentro del mdulo y tambin acceder a los eventos
    '     ( Estn declarados con WithEvents )
    Set mHSBar = hScrollBar
    Set mOwnerForm = OwnerForm
    ' -- Referncia al control contenedor de las barras ( puede ser el form, un picture o un frame), _
         No est implementado para mas de un contenedor, por ejemplo un Frame dentro de un picture, y las barras dentro del frame
    Set mParent = mHSBar.Container
    ' -- Opciones del texto
    With OptionLabel
        .HideLostFocus = HideLostFocus
        .lBorderStyle = Abs(ShowBorderStyle)
    End With
    Dim xNumber As Variant
    Randomize (Timer)
    xNumber = CInt(Rnd * 32000)
    ' -- Crear nombres nicos de controles ( Por si se utilizan varias instancias del mdulo)
    mNameLabel = "Label" & CStr(Val(xNumber))
    mNameContainer = "PicContainer" & CStr(Val(xNumber))
    
    ' -- Crear controles en forma dinmica ( contenedor y label para el texto)
    With mOwnerForm
        Set mPicContainer = .Controls.Add("vb.PictureBox", mNameContainer)
        Set mText = .Controls.Add("vb.Label", mNameLabel)
    End With
    
    ' -- Setear el Scrollbar
    With mHSBar
        .Min = MinValue
        .Max = MaxValue
        .Value = iValue
        .SmallChange = iSmallChange
        .LargeChange = iLargeChange
        Set .Container = mPicContainer
    End With
    ' -- Setear el contenedor
    With mPicContainer
        .BorderStyle = 0
        .Width = mHSBar.Width
        .BackColor = mParent.BackColor
        .Visible = True
        Set .Container = mParent
    End With
    ' -- Setear el Label
    With mText
        .FontName = "Verdana"
        .BorderStyle = OptionLabel.lBorderStyle
        .BackStyle = 0
        .ForeColor = lForeColorText
        .AutoSize = True
        Set .Container = mPicContainer
        If (OptionLabel.HideLostFocus = False) Then
            .Visible = True
        End If
    End With
    
    If Not mParent Is Nothing Then Set mParent = Nothing
    
    Exit Sub
    ' -- Errores
Error_Handler:
    MsgBox Err.Number, vbCritical, "Error en INIT"
End Sub
' -------------------------------------------------------------------------------------
' \\ -- Evento de cambio de valor de la barra de desplazamiento
' -------------------------------------------------------------------------------------
Private Sub mHSBar_Change()
    Call pvShowValue
End Sub
' -------------------------------------------------------------------------------------
' \\ -- Evento cuando obtiene el foco la barra de desplazamiento
' -------------------------------------------------------------------------------------
Private Sub mHSBar_GotFocus()
    With mText
        .Visible = True
    End With
    Call mHSBar_Change
End Sub
' -------------------------------------------------------------------------------------
' \\ -- Interceptar el evento KeyDown de la barra, _
'       para cambiar el valor con las teclas izquierda y derecha
'       La magnitud del cambio la define el valor SmallChange pasado en la funcin Init de este mdulo
' -------------------------------------------------------------------------------------
Private Sub mHSBar_KeyDown(KeyCode As Integer, Shift As Integer)
    With mHSBar
        ' -- Tecla izquierda ( Disminuir valor )
        Select Case KeyCode
            Case vbKeyLeft
                If (.Value - .SmallChange) < .Min Then
                    .Value = .Min
                Else
                    .Value = .Value - .SmallChange
                End If
        ' -- Tecla derecha ( Aumentar el valor )
            Case vbKeyRight
                If (.Value + .SmallChange) > .Max Then
                    .Value = .Max
                Else
                    .Value = .Value + .SmallChange
                End If
        End Select
    End With
End Sub
' -------------------------------------------------------------------------------------
' \\ -- Interceptar el evento LostFocus para ocultar el Value en caso de haber pasado
'       el Valor True en el parmetro HideLostFocus de la funcin Init
' -------------------------------------------------------------------------------------
Private Sub mHSBar_LostFocus()
    On Error GoTo Error_Handler
    mText.Visible = Not (OptionLabel.HideLostFocus)
    ' -- Errores
    Exit Sub
Error_Handler:
End Sub
' -------------------------------------------------------------------------------------
' \\ -- Actualizar label/texto en el Evento de Scroll de la barra de desplazamiento
' -------------------------------------------------------------------------------------
Private Sub mHSBar_Scroll()
    Call pvShowValue
End Sub
' -------------------------------------------------------------------------------------
' \\ -- Procedimiento privado para mostrar el valor al cambiar el scroll
' -------------------------------------------------------------------------------------
Private Sub pvShowValue()
    Dim k As Double
    If (Not mHSBar Is Nothing) Or (Not mText Is Nothing) Then
        With mText
            .Caption = Trim(Str(mHSBar.Value))
            k = Len(.Caption)
            .Move (y + x * (mHSBar.Value - mHSBar.Min) - (k * 50) - 10), (mHSBar.Top - .Height)
            ' -- Lanzar evento ( es el mismo que se puede acceder desde el
            '    form con la propiedad Scroll/Change de la barra. Est implementado nada mas,
            '    por si se desea hacer alguna validacin, o enviar algn parmetro extra)
            RaiseEvent ChangeValue(CInt(.Caption))
        End With
    End If
End Sub
' -------------------------------------------------------------------------------------
' \\ -- La nica forma que se me ocurri de poder corregir el
'       error de posicionar el valor al iniciar el mdulo
'       ya que si no no lo acutualizaba.
' -------------------------------------------------------------------------------------
Private Sub mOwnerForm_Activate()
    ' -- Se ejecuta una solo vez ( Actualiza la posicin del
    '    label con respecto al botn de la barra)
    If Not bInitActivateFlag Then
       bInitActivateFlag = True
       Call pvShowValue
    End If
End Sub
' -------------------------------------------------------------------------------------
' \\ -- Redimensionar contenedor del texto
' -------------------------------------------------------------------------------------
Private Sub mPicContainer_Resize()
    ' -- Posicionar y redimensionar el label y la barra
    With mText
        .Move 0, 0, 540, 225
        mHSBar.Move 0, (.Top + .Height)
    End With
    ' -- Posicionar y redimensionar el contenedor
    With mPicContainer
        .Width = mHSBar.Width
        .Height = mText.Height + mHSBar.Height
        x = ((.Width - 600) / (mHSBar.Max - mHSBar.Min))
        y = 300
    End With
End Sub
' -------------------------------------------------------------------------------------
' \\ -- Mtodo para posicionar las barras ( la posicin
'       izquierda, el top, el ancho y alto)
' -------------------------------------------------------------------------------------
Sub MoveHS(x As Single, y As Single, x1 As Single, Optional y1 As Single = 255)
    With mPicContainer
        .Left = x
        .Top = y
    End With
    With mHSBar
        .Width = x1
        .Height = y1
    End With
    Call mPicContainer_Resize
End Sub
' ------------------------------------------------------------------------------------
' \\ -- Propiedades para definir la ubicacin y dimensiones de la barra
' ------------------------------------------------------------------------------------
Property Get Width() As Single
    Width = mPicContainer.Width
End Property
Property Get Height() As Single
    Height = mPicContainer.Height
End Property
Property Get Top() As Single
    Top = mPicContainer.Top
End Property
Property Get Left() As Single
    Left = mPicContainer.Left
End Property
' -------------------------------------------------------------------------------------
' \\ -- Propiedad para recuperar el valor actual, Mnimo y mximo
' -------------------------------------------------------------------------------------
Property Get Value() As Integer
    Value = CInt(mText.Caption)
End Property
Property Let Value(iValue As Integer)
    mHSBar.Value = iValue
    Call mHSBar_Change
End Property
' -------------------------------------------------------------------------------------
' \\ -- Propiedad para guardar un valor por defecto y luego poder restaurar
'       Importante: No se comprueba que de error con los Min,Max, Value, al asignar la propiedad
' -------------------------------------------------------------------------------------
Property Get DefaultValue() As Integer
    DefaultValue = mDefaultValue
End Property
Property Let DefaultValue(ByVal iValue As Integer)
    mDefaultValue = iValue
    If Not mHSBar Is Nothing Then
        mHSBar.Value = mDefaultValue
        Call pvShowValue
    End If
End Property


