VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clasBackGround"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
 Option Explicit

Private Declare Function StretchBlt _
    Lib "gdi32" ( _
        ByVal hdc As Long, _
        ByVal x As Long, _
        ByVal y As Long, _
        ByVal nWidth As Long, _
        ByVal nHeight As Long, _
        ByVal hSrcDC As Long, _
        ByVal xSrc As Long, _
        ByVal ySrc As Long, _
        ByVal nSrcWidth As Long, _
        ByVal nSrcHeight As Long, _
        ByVal dwRop As Long) As Long

Private Declare Function SetStretchBltMode _
    Lib "gdi32" ( _
        ByVal hdc As Long, _
        ByVal nStretchMode As Long) As Long

Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function SelectObject _
    Lib "gdi32" ( _
        ByVal hdc As Long, _
        ByVal hObject As Long) As Long

Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long

Private picBackGround As StdPicture
Private mImagen       As String
Private mScaleMargin  As Integer
Private WithEvents mForm      As Form
 

Private Function ScaleImage( _
    Optional Img As StdPicture, _
    Optional pObj As Form, _
    Optional pScaleMargin As Integer)

Dim PLeft As Long, PTop As Long
Dim ReqWidth As Long, ReqHeight As Long
Dim HScale As Double, VScale As Double
Dim MyScale As Double
Dim ImgWidth As Long
Dim ImgHeight As Long
Dim SourceHDC As Long
Dim OldScale As Integer
    
    
    With pObj
         OldScale = .ScaleMode
        .ScaleMode = vbPixels
        .Cls
    
        ImgWidth = .ScaleX(Img.Width, vbHimetric, vbPixels)
        ImgHeight = .ScaleY(Img.Height, vbHimetric, vbPixels)
    
        HScale = (.ScaleWidth / ImgWidth)
        VScale = (.ScaleHeight / ImgHeight)
    End With
    
    MyScale = IIf(VScale >= HScale, HScale, VScale)
    
    ReqWidth = (ImgWidth * MyScale) - pScaleMargin
    ReqHeight = (ImgHeight * MyScale) - pScaleMargin
    

    PLeft = ((pObj.ScaleWidth - ReqWidth)) / 2
    PTop = ((pObj.ScaleHeight - ReqHeight)) / 2
      
    SourceHDC = CreateCompatibleDC(0)
    DeleteObject SelectObject(SourceHDC, Img.Handle)


    SetStretchBltMode pObj.hdc, vbPaletteModeNone


    If Img.Type = 3 Then
        pObj.PaintPicture Img, PLeft, PTop, ReqWidth, ReqHeight
    Else

        StretchBlt pObj.hdc, PLeft, PTop, ReqWidth, ReqHeight, _
                  SourceHDC, 0, 0, ImgWidth, ImgHeight, vbSrcCopy
   
        DeleteDC SourceHDC

    End If

    pObj.ScaleMode = OldScale

End Function

Sub Refresh()
    Call ScaleImage(picBackGround, mForm)
End Sub

Property Get Imagen() As String
    Imagen = mImagen
End Property

Property Let Imagen(value As String)
    If Len(Dir(Imagen)) = 0 Then
       MsgBox "No se ha encontrado el archivo", vbCritical
    Else
        mImagen = value
        Set picBackGround = LoadPicture(value)
    End If
End Property

Property Get Form() As Form
    Set Form = mForm
End Property

Property Set Form(value As Form)
    Set mForm = value
    mForm.AutoRedraw = True
End Property

Property Get ScaleMargin() As Integer
    ScaleMargin = mScaleMargin
End Property

Property Let ScaleMargin(value As Integer)
    mScaleMargin = value
End Property


Private Sub Class_Terminate()
    If Not mForm Is Nothing Then
       Set mForm = Nothing
    End If
    If Not picBackGround Is Nothing Then
       Set picBackGround = Nothing
    End If
End Sub

Private Sub mForm_Resize()
    If Not mForm Is Nothing And Not picBackGround Is Nothing Then
        ScaleImage picBackGround, mForm, mScaleMargin
    End If
End Sub
