VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3825
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   7455
   LinkTopic       =   "Form1"
   ScaleHeight     =   3825
   ScaleWidth      =   7455
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame1 
      Caption         =   "Datos de la planilla"
      Height          =   3615
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   7215
      Begin VB.PictureBox Picture1 
         BorderStyle     =   0  'None
         Height          =   3255
         Left            =   120
         ScaleHeight     =   3255
         ScaleWidth      =   6975
         TabIndex        =   1
         Top             =   240
         Width           =   6975
         Begin VB.CommandButton Command1 
            Caption         =   "Importar"
            Height          =   375
            Left            =   4320
            TabIndex        =   2
            Top             =   2760
            Width           =   1815
         End
         Begin MSFlexGridLib.MSFlexGrid MSFlexGrid1 
            Height          =   2535
            Left            =   120
            TabIndex        =   3
            Top             =   120
            Width           =   6135
            _ExtentX        =   10821
            _ExtentY        =   4471
            _Version        =   393216
         End
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' \\ -- Autor :         Luciano Lodola -- http://www.recursosvisualbasic.com.ar/

' ---------------------------------------------------------------------------------

' \\ Declaraciones ( Apis )
' ------------------------------------------------------------------------------------------
Private Declare Function SetErrorMode Lib "kernel32" (ByVal wMode As Long) As Long
Private Declare Sub InitCommonControls Lib "Comctl32" ()


' -- Variables para acceder a la hoja excel
Private obj_Excel       As Object
Private obj_Workbook    As Object
Private obj_Worksheet   As Object

Private Sub Form_Initialize()
    Call SetErrorMode(2)
    Call InitCommonControls
End Sub

' ----------------------------------------------------------------------------------
' \\ -- Inicio
' ----------------------------------------------------------------------------------
Private Sub Form_Load()
    Me.Caption = " Importar Excel a FlexGrid "
    Command1.Caption = " Importar a Flexgrid "
    ' -- Configurar el Grid
    With MSFlexGrid1
        .Cols = 10
        .FixedCols = 0
        .FormatString = "Fecha|Gastos"
        .ColWidth(0) = 2000
        .ColWidth(1) = 1500
    End With
End Sub
' ----------------------------------------------------------------------------------
' \\ -- Fin
' ----------------------------------------------------------------------------------
Private Sub Form_Unload(Cancel As Integer)
    Call Descargar
End Sub

' ----------------------------------------------------------------------------------
' \\ -- Funcin para leer los datos del Excel y cargarlos en el Flex
' ----------------------------------------------------------------------------------
Private Function Excel_FlexGrid(sPath As String, FlexGrid As Object, Filas As Integer, Columnas As Integer, Optional sSheetName As String = vbNullString) As Boolean

    Dim i As Long
    Dim n As Long
    
    On Error GoTo error_sub
    ' -- Comproba si existe l archivo
    If Len(Dir(sPath)) = 0 Then
       MsgBox "No se ha encontrado el archivo: " & sPath, vbCritical
       Exit Function
    End If
    
    FlexGrid.Redraw = False
    
    Me.MousePointer = vbHourglass
    ' -- crea rnueva instancia de Excel
    Set obj_Excel = CreateObject("Excel.Application")
    'obj_Excel.Visible = True
    
    ' -- Abrir el libro
    Set obj_Workbook = obj_Excel.Workbooks.Open(sPath)
    ' -- referencia la Hoja, por defecto la hoja activa
    If sSheetName = vbNullString Then
        Set obj_Worksheet = obj_Workbook.ActiveSheet
    Else
        Set obj_Worksheet = obj_Workbook.Sheets(sSheetName)
    End If
    
    ' -- Setear Grid
    With MSFlexGrid1
        ' -- Especificar  la cantidad de filas y columnas
        '.Cols = Columnas
        .Rows = Filas
        ' -- Recorrer las filas del FlexGrid para agregar los datos
        For i = 1 To .Rows - 1
            ' -- Establecer la fila activa
            .Row = i
            ' -- Recorrer las columnas del FlexGrid
            For n = 0 To .Cols - 1
                ' -- Establecer columna activa
                .Col = n
                ' -- Asignar a la celda del Flex el contenido de la celda del excel
                .Text = obj_Worksheet.Cells(i + 1, n + 1).Value
            Next
        Next
    End With
    ' -- Cerrar libro
    obj_Workbook.Close
    ' -- Cerrar Excel
    obj_Excel.quit
    ' -- Descargar objetos para liberar recursos
    Call Descargar
    Excel_FlexGrid = True
    FlexGrid.Redraw = True
' -- Errores
Exit Function
error_sub:
    MsgBox Err.Description
    Call Descargar
    Me.MousePointer = vbDefault
    FlexGrid.Redraw = True
End Function

Private Sub HighLight_Cells(Grid As Object, cdblMinValue As Double, iCurrentCol As Integer)
    Dim iRow As Integer
    With Grid
        .Redraw = False
        For iRow = 1 To Grid.Rows - 1
            ' -- Establecer Columna y fila activa
            .Col = iCurrentCol
            .Row = iRow
            
            ' -- Comparar el valor
            If IsNumeric(.TextMatrix(iRow, iCurrentCol)) Then
                If CDbl(.TextMatrix(iRow, iCurrentCol)) >= cdblMinValue Then
                    ' -- Remarcar y resaltar de color esta celda
                    .CellForeColor = vbRed
                End If
            End If
        Next
        .Redraw = True
    End With
End Sub


' ----------------------------------------------------------------------------------
' \\ -- Funcin para descargar los objetos
' ----------------------------------------------------------------------------------
Private Sub Descargar()
    On Local Error Resume Next
    Set obj_Workbook = Nothing
    Set obj_Excel = Nothing
    Set obj_Worksheet = Nothing
    Me.MousePointer = vbDefault
End Sub
' ----------------------------------------------------------------------------------
' \\ -- Botn para leer los datos del libro e importarlos al Grid
' ----------------------------------------------------------------------------------
Private Sub Command1_Click()
    If Excel_FlexGrid(App.Path & "\data\libro.xls", MSFlexGrid1, 20, 5, "Sheet1") Then
        Call HighLight_Cells(MSFlexGrid1, CDbl("20"), 1)
    End If
End Sub
