VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMRU"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit


' ------------------------------------------------------------------------------------
' \\ -- UDTs , Constantes
' ------------------------------------------------------------------------------------

' -- UDT requerida por GetOpenFileName
Private Type OPENFILENAME
    lStructSize As Long
    hwndOwner As Long
    hInstance As Long
    lpstrFilter As String
    lpstrCustomFilter As String
    nMaxCustFilter As Long
    nFilterIndex As Long
    lpstrFile As String
    nMaxFile As Long
    lpstrFileTitle As String
    nMaxFileTitle As Long
    lpstrInitialDir As String
    lpstrTitle As String
    flags As Long
    nFileOffset As Integer
    nFileExtension As Integer
    lpstrDefExt As String
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
End Type

' --------------------------------------------------------------------------
' \\ -- APIs
' --------------------------------------------------------------------------
' -- Apis para leer y escribir en el INI
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lpFileName As String) As Long
Private Const SECCION As String = "MRU-List"
' -- Api para obtener el archivo solo del path, y poder mostrarlo en el men
Private Declare Function GetFileTitle Lib "comdlg32.dll" Alias "GetFileTitleA" (ByVal lpszFile As String, ByVal lpszTitle As String, ByVal cbBuf As Integer) As Integer
' -- Api para abrir el dilogo de windows ( Abrir archivo ...)
Private Declare Function GetOpenFileName Lib "comdlg32.dll" Alias "GetOpenFileNameA" (pOpenfilename As OPENFILENAME) As Long

' --------------------------------------------------------------------------
' \\ -- Variables
' --------------------------------------------------------------------------
Private mColMRUPaths            As Collection   ' -- Coleccin para almacenar las rutas de los accesos directos MRU
Private mMRUCount               As Integer      ' -- Cantidad de MRU a utilizar y guardar en el INI
Private mINIPath                As String       ' -- Ruta del archivo INI
Private mMenu                   As Object       ' -- Referencia al men que se utilizar para mostrar los MRU
Private mSepMenu                As Object       ' -- Referencia al men separador

' ---------------------------------------------------------------------------------------------
' \\ -- Inicio del mdulo - Se referencian los mens, y se cargan los accesos desde el INI
' ---------------------------------------------------------------------------------------------
Sub Init(MRUMenu As Object, MRUSepMenu As Object)
    
    On Error GoTo Error_Handler
    
    ' -- Variables
    Dim i           As Integer
    Dim sMRUPath    As String
    
    Call pvShowErrorINIPath
    ' -- Crear nueva coleccin para los MRU
    Set mColMRUPaths = New Collection
    
    MRUMenu(1).Visible = False
    
    ' -- CArgar mens en forma dinmica con el mtodo Load de vb
    For i = 2 To 25
        Load MRUMenu(i)
        MRUMenu(i).Visible = False
    Next
    
    ' -- Leer desde el archivo INI los paths y pasarlos a la coleccin
    For i = 1 To mMRUCount
        sMRUPath = pvGetINIValue(SECCION, CStr(i))
        ' -- Comprobar que hay Path, si es un VbnullString no hay mas ,  ..salir
        If Len(sMRUPath) = 0 Then Exit For
        ' -- Pasar nuevo path a la coleccin
        mColMRUPaths.Add sMRUPath
    Next i
    
    ' -- Referencia local del men MRU y del separador
    If mMenu Is Nothing Then Set mMenu = MRUMenu
    If mSepMenu Is Nothing Then Set mSepMenu = MRUSepMenu
    
    ' -- Cargar los paths de arcivos en el men
    Call pvLoadMRUs
    
    ' -- Errores -------------------------------------------------
    Exit Sub
Error_Handler:
MsgBox Err.Description, vbCritical, "Error en Init"
End Sub

' ---------------------------------------------------------------------------------------------
' \\ -- Retornar el nombre de archivo desde un path
' ---------------------------------------------------------------------------------------------
Function GetFileName(ByVal sPath) As String
    On Error GoTo Error_Handler
    
    Dim sBuffer As String                                       ' -- Crear Buffer para retornar el valor
    sBuffer = String(255, 0)
    GetFileTitle sPath, sBuffer, Len(sBuffer)                   ' -- Pasar a GetFileTitle el path
    GetFileName = Left(sBuffer, InStr(1, sBuffer, Chr$(0)) - 1) ' -- Eliminar caracteres nulos y retornar el nombre de archivo
    Exit Function
    ' -- Errores -----------------------------------
Error_Handler:
End Function
' ---------------------------------------------------------------------------------------------
' \\ -- Agregar nueva entrada MRU, en la coleccin y en el INI
' ---------------------------------------------------------------------------------------------
Sub AddMRU(ByVal Ruta_Archivo As String)

    On Error GoTo Error_Handler
    
    Dim i As Integer
    Call pvShowErrorINIPath
    With mColMRUPaths
        ' ... si es el primero
        If .Count = 0 Then
            Call .Add(Ruta_Archivo)
        Else
            Call .Add(Ruta_Archivo, , 1)
        End If
        For i = .Count To 2 Step -1
            If mColMRUPaths(i) = Ruta_Archivo Then Call .Remove(i)
        Next
        Do While (.Count > mMRUCount)
            Call .Remove(mMRUCount + 1)
        Loop
    End With
    
    Call pvLoadMRUs     ' -- Cargar MRUs en el men
    Call pvSaveMRU      ' -- Grabar en el Ini
    ' -- Errores ---------------------------------------------------------------
    Exit Sub
Error_Handler:
MsgBox Err.Description, vbCritical, "Error en AddMru"
End Sub
' -------------------------------------------------------------------------------
' \\ --  Cargar MRus
' -------------------------------------------------------------------------------
Private Sub pvLoadMRUs()
    On Error GoTo Error_Handler
    Dim i As Integer
    ' -- Recorre la coleccin de Mrus
    For i = 1 To mColMRUPaths.Count
        ' -- Colocar el caption al man - Solo el nombre de archivo
        mMenu(i).Caption = CStr(i) & " " & GetFileName(mColMRUPaths(i))
        mMenu(i).Visible = True
    Next i
    
    ' -- Hace visible el men separador = al primer elemento
    mSepMenu.Visible = mMenu(1).Visible
    ' -- Errores ---------------------------------------------------------------
    Exit Sub
Error_Handler:
MsgBox Err.Description, vbCritical, "Error en AddMru"
End Sub
' -------------------------------------------------------------------------------
' \\ -- Guardar MRus
' -------------------------------------------------------------------------------
Private Sub pvSaveMRU()
    
    On Error GoTo Error_Handler
    Dim i As Integer
    
    ' -- Recorre la coleccin
    For i = 1 To mColMRUPaths.Count
        Call pvWriteINIValue(SECCION, CStr(i), mColMRUPaths(i))
    Next i

    'On Local Error Resume Next
    
    For i = mColMRUPaths.Count + 1 To mMRUCount
        Call pvWriteINIValue(SECCION, CStr(i), vbNullString)
    Next i
    ' -- Errores --------------------------------------------
    Exit Sub
Error_Handler:
End Sub
' -------------------------------------------------------------------------------
' \\ -- Eliminar MRus
' -------------------------------------------------------------------------------
Sub DeleteMRU()
    On Error GoTo Error_Handler
    Dim i As Integer
    Call pvShowErrorINIPath
    ' -- Ocultar todos los menues, y eliminar entradas de la seccin INI
    For i = 1 To mMenu.Count
        mMenu(i).Visible = False
        Call pvWriteINIValue(SECCION, CStr(i), vbNullString)
    Next
    ' -- Ocultar el men separador
    mSepMenu.Visible = False
    
    ' -- Eliminar coleccin y over a instanciar
    Set mColMRUPaths = Nothing
    Set mColMRUPaths = New Collection
    
    ' -- Errores ----------------------------------------------------------------
    Exit Sub
Error_Handler:
End Sub
' -------------------------------------------------------------------------------
' \\ -- Leer de la coleccin el MRU y Retornar el Path
' -------------------------------------------------------------------------------
Function GetMRU(indice_Menu As Integer) As String
    On Error GoTo Error_Handler
    Call pvShowErrorINIPath
    GetMRU = mColMRUPaths(indice_Menu)
    Exit Function
Error_Handler:
End Function
' -------------------------------------------------------------------------------
' \\ -- Dilogo de windows para seleccionar archivo
' -------------------------------------------------------------------------------
Function ShowCDlg( _
    Hwnd_form As Long, _
    Optional Filtro As String, _
    Optional path_Inicial As String, _
    Optional Dialog_title As String) As String
                            
    On Error GoTo Error_Handler
                            
    Dim OF As OPENFILENAME
    If Filtro = vbNullString Then Filtro = "Todos los archivos(*.*)" + Chr$(0) + "*.*" + Chr$(0)
    If Dialog_title = vbNullString Then Dialog_title = " Abrir archivo ... "
    
    With OF
        .lStructSize = Len(OF)
        .hwndOwner = Hwnd_form
        .hInstance = App.hInstance
        .lpstrFilter = Filtro
        .lpstrFile = Space$(254)
        .nMaxFile = 255
        .lpstrFileTitle = Space$(254)
        .nMaxFileTitle = 255
        .lpstrInitialDir = path_Inicial
        .lpstrTitle = Dialog_title
        .flags = 0
        If GetOpenFileName(OF) Then ShowCDlg = Trim$(Replace(.lpstrFile, Chr(0), vbNullString))
    End With
    
    Exit Function
Error_Handler:
End Function
' -----------------------------------------------------------------------------------
' \\ -- Propiedad que mantiene la cantidad de accesos directos a utilizar
' -----------------------------------------------------------------------------------
Public Property Get Count() As Integer
    Count = mMRUCount
End Property
Public Property Let Count(ByVal iValue As Integer)
On Local Error GoTo Error_Handler
    mMRUCount = iValue
Exit Property

Error_Handler:
MsgBox Err.Number & " : " & Err.Description, vbCritical
End Property
' -----------------------------------------------------------------------------------
' \\ -- Rutinas para leer y guardar los MRU en elarchivo INI
' -----------------------------------------------------------------------------------
Private Function pvGetINIValue(SECCION As String, Key As String, Optional Default As Variant = "") As String
On Error GoTo Error_Handler

    Dim Buffer As String * 256
    Dim ret As Long

    ret = GetPrivateProfileString(SECCION, Key, Default, Buffer, Len(Buffer), mINIPath)
    pvGetINIValue = Left$(Buffer, ret)
    
Exit Function
Error_Handler:
MsgBox Err.Description, vbCritical

End Function
Private Function pvWriteINIValue(SECCION As String, Key As String, Valor As Variant) As String
On Error GoTo Error_Handler

    Dim ret As Long
    ret = WritePrivateProfileString(SECCION, Key, Valor, mINIPath)
   
Exit Function
Error_Handler:
MsgBox Err.Description, vbCritical
   
End Function
Private Sub pvShowErrorINIPath()
    If mINIPath = vbNullString Then
        MsgBox "No se ha indicado el path del archivo Ini", vbCritical
        End
    End If
End Sub
' -----------------------------------------------------------------------------------
' \\ -- Path del archivo INI
' -----------------------------------------------------------------------------------
Property Get INIPath() As String
    INIPath = mINIPath
End Property
Property Let INIPath(ByVal sPath As String)
    mINIPath = sPath
End Property
' -----------------------------------------------------------------------------------
' \\ -- Propiedades con la coleccin de MRus
' -----------------------------------------------------------------------------------
Property Get ColMRUPaths() As Collection
    Set ColMRUPaths = mColMRUPaths
End Property
' -----------------------------------------------------------------------------------
' \\ -- Fin
' -----------------------------------------------------------------------------------
Private Sub Class_Terminate()
    Set mColMRUPaths = Nothing
End Sub
' -----------------------------------------------------------------------------------
' \\ -- Inicio
' -----------------------------------------------------------------------------------
Private Sub Class_Initialize()
    ' ---
End Sub

