Attribute VB_Name = "Module1"

Option Explicit

Public Declare Function OpenService Lib "advapi32.dll" Alias "OpenServiceA" (ByVal hSCManager As Long, ByVal lpServiceName As String, ByVal dwDesiredAccess As Long) As Long
Public Declare Function OpenSCManager Lib "advapi32.dll" Alias "OpenSCManagerA" (ByVal lpMachineName As String, ByVal lpDatabaseName As String, ByVal dwDesiredAccess As Long) As Long
Public Declare Function QueryServiceStatus Lib "advapi32.dll" (ByValhService As Long, lpServiceStatus As SERVICE_STATUS) As Long
Public Declare Function ControlService Lib "advapi32.dll" (ByVal hService As Long, ByVal dwControl As Long, lpServiceStatus As SERVICE_STATUS) As Long
Public Declare Function StartService Lib "advapi32.dll" Alias "StartServiceA" (ByVal hService As Long, ByVal dwNumServiceArgs As Long, ByVal lpServiceArgVectors As Long) As Long
Public Declare Function CloseServiceHandle Lib "advapi32.dll" (ByVal hSCObject As Long) As Long
Public Declare Function ChangeServiceConfig Lib "advapi32.dll" Alias "ChangeServiceConfigA" (ByVal hService As Long, ByVal dwServiceType As Long, ByVal dwStartType As Long, ByVal dwErrorControl As Long, ByVal lpBinaryPathName As String, ByVal lpLoadOrderGroup As String, lpdwTagId As Long, ByVal lpDependencies As String, ByVal lpServiceStartName As String, ByVal lpPassword As String, ByVal lpDisplayName As String) As Long


Const STANDARD_RIGHTS_REQUIRED = &HF0000
Const STANDARD_RIGHTS_ALL = &H1F0000
Const SPECIFIC_RIGHTS_ALL = &HFFFF


' Service database names
Const SERVICES_ACTIVE_DATABASE = "ServicesActive"
Const SERVICES_FAILED_DATABASE = "ServicesFailed"


' Value to indicate no change to an optional parameter
Const SERVICE_NO_CHANGE = &HFFFF


Const SERVICE_DEMAND_START = &H3

' Service State -- for Enum Requests (Bit Mask)
Const SERVICE_ACTIVE = &H1
Const SERVICE_INACTIVE = &H2
Const SERVICE_STATE_ALL = (SERVICE_ACTIVE Or SERVICE_INACTIVE)

' Controls
Const SERVICE_CONTROL_STOP = &H1
Const SERVICE_CONTROL_PAUSE = &H2
Const SERVICE_CONTROL_CONTINUE = &H3
Const SERVICE_CONTROL_INTERROGATE = &H4
Const SERVICE_CONTROL_SHUTDOWN = &H5


' Service State -- for CurrentState
Const SERVICE_STOPPED = &H1
Const SERVICE_START_PENDING = &H2
Const SERVICE_STOP_PENDING = &H3
Const SERVICE_RUNNING = &H4
Const SERVICE_CONTINUE_PENDING = &H5
Const SERVICE_PAUSE_PENDING = &H6
Const SERVICE_PAUSED = &H7


' Controls Accepted  (Bit Mask)
Const SERVICE_ACCEPT_STOP = &H1
Const SERVICE_ACCEPT_PAUSE_CONTINUE = &H2
Const SERVICE_ACCEPT_SHUTDOWN = &H4


' Service Control Manager object specific access types
Const SC_MANAGER_CONNECT = &H1
Const SC_MANAGER_CREATE_SERVICE = &H2
Const SC_MANAGER_ENUMERATE_SERVICE = &H4
Const SC_MANAGER_LOCK = &H8
Const SC_MANAGER_QUERY_LOCK_STATUS = &H10
Const SC_MANAGER_MODIFY_BOOT_CONFIG = &H20


Const SC_MANAGER_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED Or SC_MANAGER_CONNECT Or SC_MANAGER_CREATE_SERVICE Or SC_MANAGER_ENUMERATE_SERVICE Or SC_MANAGER_LOCK Or SC_MANAGER_QUERY_LOCK_STATUS Or SC_MANAGER_MODIFY_BOOT_CONFIG)

' Service object specific access type
Const SERVICE_QUERY_CONFIG = &H1
Const SERVICE_CHANGE_CONFIG = &H2
Const SERVICE_QUERY_STATUS = &H4
Const SERVICE_ENUMERATE_DEPENDENTS = &H8
Const SERVICE_START = &H10
Const SERVICE_STOP = &H20
Const SERVICE_PAUSE_CONTINUE = &H40
Const SERVICE_INTERROGATE = &H80
Const SERVICE_USER_DEFINED_CONTROL = &H100
Const SERVICE_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED Or SERVICE_QUERY_CONFIG Or SERVICE_CHANGE_CONFIG Or SERVICE_QUERY_STATUS Or SERVICE_ENUMERATE_DEPENDENTS Or SERVICE_START Or SERVICE_STOP Or SERVICE_PAUSE_CONTINUE Or SERVICE_INTERROGATE Or SERVICE_USER_DEFINED_CONTROL)

Public Type SERVICE_STATUS
    dwServiceType As Long
    dwCurrentState As Long
    dwControlsAccepted As Long
    dwWin32ExitCode As Long
    dwServiceSpecificExitCode As Long
    dwCheckPoint As Long
    dwWaitHint As Long
End Type


Public Function QueryService(strServiceName As String, strServerName As String) As String
    
    Dim ret As Long
    
    App.LogEvent "QueryService : " & strServiceName
    Dim lngSMHandle As Long
    Dim lngSvcHandle As Long
    Dim ssStatus As SERVICE_STATUS
    lngSMHandle = OpenSCManager(strServerName, SERVICES_ACTIVE_DATABASE, SC_MANAGER_CONNECT)
    lngSvcHandle = OpenService(lngSMHandle, strServiceName, SERVICE_QUERY_STATUS) ' SERVICE_ALL_ACCESS)
    'lngSvcHandle = OpenService(lngSMHandle, strServiceName, SERVICE_ALL_ACCESS)
    ret = QueryServiceStatus(lngSvcHandle, ssStatus)
    If lngSvcHandle = 0& Then QueryService = "Service Not Found"
    Select Case ssStatus.dwCurrentState
    Case SERVICE_STOPPED
        QueryService = "Service Is Stopped"
    Case SERVICE_START_PENDING
        QueryService = "Service Start Pending"
    Case SERVICE_STOP_PENDING
        QueryService = "Service Stop Pending"
    Case SERVICE_RUNNING
        QueryService = "Service Is Running"
    Case SERVICE_CONTINUE_PENDING
        QueryService = "Service Continue Pending"
    Case SERVICE_PAUSE_PENDING
        QueryService = "Service Pause Pending"
    Case SERVICE_PAUSED
        QueryService = "Service Paused"
    End Select
    CloseServiceHandle lngSvcHandle
    CloseServiceHandle lngSMHandle
End Function


Public Sub StopSvc(strServiceName As String, strServerName As String)
    App.LogEvent "Stop Service : " & strServiceName
    Dim lngSMHandle As Long
    Dim lngSvcHandle As Long
    Dim ssStatus As SERVICE_STATUS
    Dim ret As Long
    
    lngSMHandle = OpenSCManager(strServerName, SERVICES_ACTIVE_DATABASE, SC_MANAGER_CONNECT)
    'lngSvcHandle = OpenService(lngSMHandle, strServiceName, SERVICE_USER_DEFINED_CONTROL) 'SERVICE_ALL_ACCESS)
    lngSvcHandle = OpenService(lngSMHandle, strServiceName, SERVICE_ALL_ACCESS)
    ret = QueryServiceStatus(lngSvcHandle, ssStatus)
    If lngSvcHandle <> 0& Then
        ret = ControlService(lngSvcHandle, SERVICE_CONTROL_STOP, ssStatus)
    End If
    CloseServiceHandle lngSvcHandle
    CloseServiceHandle lngSMHandle
End Sub


Public Sub StartSvc(strServiceName As String, strServerName As String)
    App.LogEvent "Start Service : " & strServiceName
    Dim lngSMHandle As Long
    Dim lngSvcHandle As Long
    Dim ret As Long

    Dim ssStatus As SERVICE_STATUS
    lngSMHandle = OpenSCManager(strServerName, SERVICES_ACTIVE_DATABASE, SC_MANAGER_CONNECT)
    lngSvcHandle = OpenService(lngSMHandle, strServiceName, SERVICE_USER_DEFINED_CONTROL) 'SERVICE_USER_DEFINED_CONTROL)
'SERVICE_ALL_ACCESS)
    'lngSvcHandle = OpenService(lngSMHandle, strServiceName, SERVICE_ALL_ACCESS)
    ret = QueryServiceStatus(lngSvcHandle, ssStatus)
    If lngSvcHandle <> 0& Then
        'rep = StartService(lngSvcHandle, 0&, 0&)
        ret = ChangeServiceConfig(lngSvcHandle, SERVICE_NO_CHANGE, SERVICE_DEMAND_START, SERVICE_NO_CHANGE, 0&, 0&, 0&, 0&, 0&, 0&, 0&)
        ret = StartService(lngSvcHandle, 0&, 0&)
    End If
    CloseServiceHandle lngSvcHandle
    CloseServiceHandle lngSMHandle
End Sub
