Attribute VB_Name = "Module2"

Option Explicit
Dim Rst As ADODB.Recordset


' DEclaracin de la Funcin Api SendMessage
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" ( _
    ByVal hwnd As Long, _
    ByVal wMsg As Long, _
    ByVal wParam As Long, _
    lParam As Any) As Long

Private Const WM_SETREDRAW As Long = &HB&


Sub Cargar_ListView( _
        ListView As ListView, _
        sql As String, _
        cnn As ADODB.Connection, _
        Optional SmallIconIndex As Integer = 0)

    Dim Campo As Integer

    'On Error GoTo ErrSub

    
    Dim Item As ListItem
    Dim i As Long


    Set Rst = New Recordset

    
    Rst.Open sql, cnn, adOpenDynamic, adLockOptimistic
    
    With ListView
    
        .View = lvwReport
    
        .ListItems.Clear
        .ColumnHeaders.Clear
    End With

    Screen.MousePointer = vbHourglass

    'Agrega los nombres campo junto con los encabezados de columna para el ListView
    For Campo = 0 To Rst.Fields.Count - 1
        ListView.ColumnHeaders.Add , , Rst.Fields(Campo).Name
    Next

    ' Recorre todos los registros del Recordset
    While Not Rst.EOF
        
        'Agrega el Item
        Set Item = ListView.ListItems.Add(, , Rst.Fields(0), , SmallIconIndex)
        i = 1

        'Agrega los SubItem
        For Campo = 1 To Rst.Fields.Count - 1
            
            If Not IsNull(Rst.Fields(Campo)) Then
                Item.SubItems(i) = Rst.Fields(Campo)
            End If
            i = i + 1
        Next
    
    'Siguiente registro
    Rst.MoveNext
    Wend

    Screen.MousePointer = vbDefault

Exit Sub
'Error
ErrSub:

    MsgBox Err.Description, vbCritical, "Error"
    Screen.MousePointer = vbDefault
End Sub


'****************************************************************
' Evento al hacer clic en la columna
'----------------------------------------------------------------

Sub Ordenar(ListView1 As ListView, Indice As Long, Tag As String)

    On Error Resume Next
    
    
    With ListView1
    
        Dim i As Long
        Dim Formato As String
        Dim strData() As String
        
        Dim Columna As Long
        
        Call SendMessage(ListView1.hwnd, WM_SETREDRAW, 0&, 0&)
        
        
        Columna = Indice
        
        '''''''''''''''''''''''''''''''''''''''''''''
        ' Tipo de dato a ordenar
        ''''''''''''''''''''''''''''''''''''''''''''''
        
        Select Case UCase$(Tag)
    
        
        ' Fecha
        '''''''''''''''''''''''''''''''''''''''''''''
        Case "DATE"
        
            Formato = "YYYYMMDDHhNnSs"
        
            ' Ordena alfabticamente la columna con Fechas _
              ( es la columna que tiene en el tag el valor DATE )
        
            With .ListItems
                If (Columna > 0) Then
                    For i = 1 To .Count
                        With .Item(i).ListSubItems(Columna)
                            .Tag = .Text & Chr$(0) & .Tag
                            If IsDate(.Text) Then
                                .Text = Format(CDate(.Text), _
                                                    Formato)
                            Else
                                .Text = ""
                            End If
                        End With
                    Next i
                Else
                    For i = 1 To .Count
                        With .Item(i)
                            .Tag = .Text & Chr$(0) & .Tag
                            If IsDate(.Text) Then
                                .Text = Format(CDate(.Text), _
                                                    Formato)
                            Else
                                .Text = ""
                            End If
                        End With
                    Next i
                End If
            End With
            
            ' Ordena alfabticamente
            
            .SortOrder = (.SortOrder + 1) Mod 2
            .SortKey = Indice
            .Sorted = True
            
            With .ListItems
                If (Columna > 0) Then
                    For i = 1 To .Count
                        With .Item(i).ListSubItems(Columna)
                            strData = Split(.Tag, Chr$(0))
                            .Text = strData(0)
                            .Tag = strData(1)
                        End With
                    Next i
                Else
                    For i = 1 To .Count
                        With .Item(i)
                            strData = Split(.Tag, Chr$(0))
                            .Text = strData(0)
                            .Tag = strData(1)
                        End With
                    Next i
                End If
            End With
            
        ' Datos de numricos
        '''''''''''''''''''''''''''''''''''''''''''''
        Case "NUMBER"
        
            ' Ordena alfabticamente la columna con nmeros _
              ( es la columna que tiene en el tag el valor NUMBER )
        
            Formato = String(30, "0") & "." & String(30, "0")
                
            With .ListItems
                If (Columna > 0) Then
                    For i = 1 To .Count
                        With .Item(i).ListSubItems(Columna)
                            .Tag = .Text & Chr$(0) & .Tag
                            If IsNumeric(.Text) Then
                                If CDbl(.Text) >= 0 Then
                                    .Text = Format(CDbl(.Text), _
                                        Formato)
                                Else
                                    .Text = "&" & InvNumber( _
                                        Format(0 - CDbl(.Text), _
                                        Formato))
                                End If
                            Else
                                .Text = ""
                            End If
                        End With
                    Next i
                Else
                    For i = 1 To .Count
                        With .Item(i)
                            .Tag = .Text & Chr$(0) & .Tag
                            If IsNumeric(.Text) Then
                                If CDbl(.Text) >= 0 Then
                                    .Text = Format(CDbl(.Text), _
                                        Formato)
                                Else
                                    .Text = "&" & InvNumber( _
                                        Format(0 - CDbl(.Text), _
                                        Formato))
                                End If
                            Else
                                .Text = ""
                            End If
                        End With
                    Next i
                End If
            End With
            
            ' Ordena alfabticamente
            
            .SortOrder = (.SortOrder + 1) Mod 2
            .SortKey = Indice
            .Sorted = True
            
            With .ListItems
                If (Columna > 0) Then
                    For i = 1 To .Count
                        With .Item(i).ListSubItems(Columna)
                            strData = Split(.Tag, Chr$(0))
                            .Text = strData(0)
                            .Tag = strData(1)
                        End With
                    Next i
                Else
                    For i = 1 To .Count
                        With .Item(i)
                            strData = Split(.Tag, Chr$(0))
                            .Text = strData(0)
                            .Tag = strData(1)
                        End With
                    Next i
                End If
            End With
        
        Case Else
                    
            .SortOrder = (.SortOrder + 1) Mod 2
            .SortKey = Indice
            .Sorted = True
            
        End Select
    
    End With
    
    Call SendMessage(ListView1.hwnd, WM_SETREDRAW, 1&, 0&)
    ListView1.Refresh
    
End Sub

Private Function InvNumber(ByVal Number As String) As String
    Static i As Integer
    For i = 1 To Len(Number)
        Select Case Mid$(Number, i, 1)
        Case "-": Mid$(Number, i, 1) = " "
        Case "0": Mid$(Number, i, 1) = "9"
        Case "1": Mid$(Number, i, 1) = "8"
        Case "2": Mid$(Number, i, 1) = "7"
        Case "3": Mid$(Number, i, 1) = "6"
        Case "4": Mid$(Number, i, 1) = "5"
        Case "5": Mid$(Number, i, 1) = "4"
        Case "6": Mid$(Number, i, 1) = "3"
        Case "7": Mid$(Number, i, 1) = "2"
        Case "8": Mid$(Number, i, 1) = "1"
        Case "9": Mid$(Number, i, 1) = "0"
        End Select
    Next
    InvNumber = Number
End Function



