Attribute VB_Name = "Module1"
'---------------------------------------------
' Module      : MdlLVProgress
' DateTime    : 16/12/2007
' Author      : Leandro Ascierto
' Mail        : leandroascierto@hotmail.com
'---------------------------------------------
Option Explicit

Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function Rectangle Lib "gdi32" (ByVal hdc As Long, ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function CreatePen Lib "gdi32" (ByVal nPenStyle As Long, ByVal nWidth As Long, ByVal crColor As Long) As Long
Private Declare Function CreateBrushIndirect Lib "gdi32" (lpLogBrush As LOGBRUSH) As Long
Private Declare Function DrawTextEx Lib "user32" Alias "DrawTextExA" (ByVal hdc As Long, ByVal lpsz As String, ByVal n As Long, lpRect As RECT, ByVal un As Long, ByVal lpDrawTextParams As Any) As Long
Private Declare Function SetBkMode Lib "gdi32" (ByVal hdc As Long, ByVal nBkMode As Long) As Long
Private Declare Function SendMessageLong Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function GetTextMetrics Lib "gdi32" Alias "GetTextMetricsA" (ByVal hdc As Long, lpMetrics As TEXTMETRIC) As Long
Private Declare Function SetProp Lib "user32.dll" Alias "SetPropA" (ByVal hwnd As Long, ByVal lpString As String, ByVal hData As Long) As Long
Private Declare Function GetProp Lib "user32.dll" Alias "GetPropA" (ByVal hwnd As Long, ByVal lpString As String) As Long
Private Declare Function RemoveProp Lib "user32.dll" Alias "RemovePropA" (ByVal hwnd As Long, ByVal lpString As String) As Long


Private Type TEXTMETRIC
    tmHeight As Long
    tmAscent As Long
    tmDescent As Long
    tmInternalLeading As Long
    tmExternalLeading As Long
    tmAveCharWidth As Long
    tmMaxCharWidth As Long
    tmWeight As Long
    tmOverhang As Long
    tmDigitizedAspectX As Long
    tmDigitizedAspectY As Long
    tmFirstChar As Byte
    tmLastChar As Byte
    tmDefaultChar As Byte
    tmBreakChar As Byte
    tmItalic As Byte
    tmUnderlined As Byte
    tmStruckOut As Byte
    tmPitchAndFamily As Byte
    tmCharSet As Byte
End Type

Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type


Private Type LOGBRUSH
    lbStyle As Long
    lbColor As Long
    lbHatch As Long
End Type

Public Type LV_ITEM
    mask As Long
    iItem As Long
    iSubItem As Long
    State As Long
    stateMask As Long
    pszText As Long
    cchTextMax As Long
    iImage As Long
    lParam As Long
    iIndent As Long
End Type


Private Const LVM_FIRST As Long = &H1000
Private Const LVM_GETITEMCOUNT As Long = (LVM_FIRST + 4)
Private Const LVM_GETITEMTEXTA As Long = (LVM_FIRST + 45)
Private Const LVM_GETSUBITEMRECT As Long = (LVM_FIRST + 56)

Private Const WM_PAINT As Long = &HF&

Private Const LVIF_TEXT = &H1
Private Const LVIR_LABEL = 2

Private Const GWL_WNDPROC = (-4)

Private Const DT_CENTER = &H1
Private Const DT_WORDBREAK = &H10
Private Const TRANSPARENT = 1

Private bShowPercent As Boolean
Private lMaximo As Long

Dim PrevProc As Long




Public Function SetBackColor(hwnd As Long, Color As Long)
    SetProp hwnd, "BackColor", Color
End Function

Public Function SetBorderColor(hwnd As Long, Color As Long)
    SetProp hwnd, "BorderColor", Color
End Function

Public Function SetForeColor(hwnd As Long, Color As Long)
    SetProp hwnd, "ForeColor", Color
End Function

Public Function SetDisplayValue( _
    hwnd As Long, _
    Value As Boolean, _
    bMostrarPercent As Boolean, _
    lngMaximoValor As Long)
    
    lMaximo = lngMaximoValor
    
    bShowPercent = bMostrarPercent
    SetProp hwnd, "DisplayValue", Value
    
End Function

Public Function SetSubItemsProgress(hwnd As Long, Index As Integer)
    SetProp hwnd, "SubItemsProgress", Index
End Function

Public Sub HookListView(hwnd As Long)
    If GetProp(hwnd, "PrevProc") = 0 Then
        PrevProc = SetWindowLong(hwnd, GWL_WNDPROC, AddressOf WindowProc)
        SetProp hwnd, "PrevProc", PrevProc
    End If
End Sub
Public Sub UnHookListView(hwnd As Long)
    SetWindowLong hwnd, GWL_WNDPROC, PrevProc
    SetProp hwnd, "PrevProc", 0
End Sub
Public Function WindowProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
   
 
   WindowProc = CallWindowProc(GetProp(hwnd, "PrevProc"), hwnd, uMsg, wParam, lParam)

'Debug.Print uMsg, wParam, lParam
    

If uMsg = WM_PAINT Then

    Dim DC As Long
    Dim Count As Long
    Dim i As Integer
    Dim Rec As RECT
    Dim R As RECT
    Dim hRPen As Long
    Dim hBrush As Long
    Dim ItemValue As Long
    Dim Value As Long
    Dim LB As LOGBRUSH
    Dim tm As TEXTMETRIC
    
    DC = GetDC(hwnd)
    Count = SendMessage(hwnd, LVM_GETITEMCOUNT, 0, 0)

    

    GetClientRect hwnd, R
    
    
    For i = 0 To Count - 1
    
        Rec.Top = GetProp(hwnd, "SubItemsProgress")
        Rec.Left = LVIR_LABEL
        SendMessage hwnd, LVM_GETSUBITEMRECT, i, Rec
    
        If Rec.Top > 10 Then
            
            LB.lbColor = GetProp(hwnd, "BackColor")
            LB.lbStyle = 2
            LB.lbHatch = 6
            hBrush = CreateBrushIndirect(LB)
            hRPen = CreatePen(0, 1, GetProp(hwnd, "BorderColor"))
            DeleteObject SelectObject(DC, hBrush)
            DeleteObject SelectObject(DC, hRPen)
            Rectangle DC, Rec.Left, Rec.Top + 1, Rec.Right, Rec.Bottom - 1
            
            DeleteObject hBrush
            DeleteObject hRPen
            
            ItemValue = GetListItem(hwnd, i, GetProp(hwnd, "SubItemsProgress"))
            Dim ItemValue2 As String
            
            ItemValue2 = CStr(ItemValue)
            
            ItemValue = CLng(ItemValue * 100) / lMaximo
            
            
            If ItemValue > 0 Then
                LB.lbColor = GetProp(hwnd, "ForeColor")
                LB.lbStyle = 2
                LB.lbHatch = 6
                
                hBrush = CreateBrushIndirect(LB)
                hRPen = CreatePen(0, 0, GetProp(hwnd, "ForeColor"))
                
                DeleteObject SelectObject(DC, hBrush)
                DeleteObject SelectObject(DC, hRPen)
        
                
                Value = (ItemValue * (Rec.Right - Rec.Left)) / 100
                
                If ItemValue < 100 Then
                    Rectangle DC, Rec.Left + 1, Rec.Top + 2, Rec.Left + Value, Rec.Bottom - 2
                Else
                    Rectangle DC, Rec.Left + 1, Rec.Top + 2, Rec.Right - 1, Rec.Bottom - 2
                End If
                
                DeleteObject hBrush
                DeleteObject hRPen
            End If
            
               

            If GetProp(hwnd, "DisplayValue") Then
                GetTextMetrics DC, tm
                Rec.Top = (Rec.Top - (Rec.Top - Rec.Bottom) / 2) - ((tm.tmHeight) / 2)
                SetBkMode DC, TRANSPARENT
                Dim sItemValue As String
                
                If bShowPercent Then
                   
                   sItemValue = CStr(ItemValue) & " %"
                Else
                   sItemValue = ItemValue2 & " "
                End If
                
                DrawTextEx DC, sItemValue, Len(sItemValue), Rec, DT_WORDBREAK Or DT_CENTER, ByVal 0&
            End If
                
    
        End If
        
        If R.Bottom < Rec.Bottom Then
            Exit For
        End If
    
    Next i
    DeleteDC DC
End If


End Function


Private Function GetListItem(hwnd As Long, ByVal iItem As Long, ByVal iSubItem As Long) As Long
 On Error Resume Next
    Dim objItem As LV_ITEM
    Dim baBuffer(32) As Byte
    Dim lngLength As Long

    objItem.mask = LVIF_TEXT
    objItem.iSubItem = iSubItem
    objItem.pszText = VarPtr(baBuffer(0))
    objItem.cchTextMax = UBound(baBuffer)
    lngLength = SendMessageLong(hwnd, LVM_GETITEMTEXTA, iItem, VarPtr(objItem))
    GetListItem = Left$(StrConv(baBuffer, vbUnicode), lngLength)


End Function



