Attribute VB_Name = "Module2"

Option Explicit
Dim Rst As ADODB.Recordset


Sub Cargar_ListView( _
        ListView As ListView, _
        sql As String, _
        cnn As ADODB.Connection, _
        IndexColImagen As Integer, _
        lngMaximoValor As Long, _
        Optional bDisplayValue As Boolean, _
        Optional bMostrarPercent As Boolean, _
        Optional BackColor As Long = vbWhite, _
        Optional BorderColor As Long = vbRed, _
        Optional ForeColor As Long = vbBlack, _
        Optional SmallIconIndex As Integer = 0)

    Dim Campo As Integer

    On Error GoTo ErrSub

    
    Dim Item As ListItem
    Dim i As Long


    Set Rst = New Recordset

    
    Rst.Open sql, cnn, adOpenDynamic, adLockOptimistic
    
    With ListView
    
        .View = lvwReport
    
        .ListItems.Clear
        .ColumnHeaders.Clear
    End With

    Screen.MousePointer = vbHourglass

    'Agrega los nombres campo junto con los encabezados de columna para el ListView
    For Campo = 0 To Rst.Fields.Count - 1
        ListView.ColumnHeaders.Add , , Rst.Fields(Campo).Name
    Next

    ' Recorre todos los registros del Recordset
    While Not Rst.EOF
        
        'Agrega el Item
        Set Item = ListView.ListItems.Add(, , Rst.Fields(0), , SmallIconIndex)
        i = 1

        'Agrega los SubItem
        For Campo = 1 To Rst.Fields.Count - 1
            
            If Not IsNull(Rst.Fields(Campo)) And IndexColImagen = Campo Then
               Item.SubItems(i) = CLng(Rst.Fields(Campo))
            
            ElseIf Not IsNull(Rst.Fields(Campo)) Then
                Item.SubItems(i) = Rst.Fields(Campo)
            End If
            i = i + 1
        Next
    
    'Siguiente registro
    Rst.MoveNext
    Wend

    Screen.MousePointer = vbDefault
    
    With ListView
    
        SetBackColor .hwnd, BackColor ' color del fondo de la barra de progreso
        SetBorderColor .hwnd, BorderColor 'color del borde de la barra de progreso
        SetForeColor .hwnd, ForeColor 'color de la barra de progreso
        SetSubItemsProgress .hwnd, IndexColImagen 'index del subitems que se quiere mostrar el progressbar
        SetDisplayValue .hwnd, bDisplayValue, bMostrarPercent, lngMaximoValor ' Motrar el display del porcentaje
        HookListView .hwnd 'llamada a la subclasificacion del ListView
        
        .Refresh
    End With

Exit Sub
'Error
ErrSub:

    MsgBox Err.Description, vbCritical, "Error"
    Screen.MousePointer = vbDefault
End Sub
