VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 1  'vbDataSource
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsProductos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Dim WithEvents mRs As Recordset
Attribute mRs.VB_VarHelpID = -1
Private DoingRequery As Boolean
Public Event MoveComplete()

Private mConnectionString As String

Function Iniciar(query As String) As Boolean

  On Error GoTo error_Init

  Dim db As Connection
  Set db = New Connection
  db.CursorLocation = adUseClient
  
  db.Open mConnectionString

  Set mRs = New Recordset
  mRs.Open query, db, adOpenStatic, adLockOptimistic

  DataMembers.Add "Primary"
  Iniciar = True
Exit Function

error_Init:
MsgBox Err.Description

End Function

Property Get ConnectionString() As String
    ConnectionString = mConnectionString
End Property
Property Let ConnectionString(value As String)
    mConnectionString = value
End Property

Private Sub Class_GetDataMember(DataMember As String, Data As Object)
  Select Case DataMember
  Case "Primary"
    Set Data = mRs
  End Select
End Sub

Private Sub mRs_MoveComplete( _
    ByVal adReason As ADODB.EventReasonEnum, _
    ByVal pError As ADODB.Error, _
    adStatus As ADODB.EventStatusEnum, _
    ByVal pRecordset As ADODB.Recordset)
  
  RaiseEvent MoveComplete
End Sub

Private Sub mRs_WillChangeRecord( _
    ByVal adReason As ADODB.EventReasonEnum, _
    ByVal cRecords As Long, _
    adStatus As ADODB.EventStatusEnum, _
    ByVal pRecordset As ADODB.Recordset)
  
  'Aqu se coloca el cdigo de validacin
  'Se llama a este evento cuando ocurre la siguiente accin
  Dim bCancel As Boolean
  Select Case adReason
    Case adRsnAddNew
    Case adRsnClose
    Case adRsnDelete
    Case adRsnFirstChange
    Case adRsnMove
    Case adRsnRequery
    Case adRsnResynch
    Case adRsnUndoAddNew
    Case adRsnUndoDelete
    Case adRsnUndoUpdate
    Case adRsnUpdate
  End Select

  If bCancel Then adStatus = adStatusCancel
End Sub

Public Property Get RecordCount() As Long
  RecordCount = mRs.RecordCount
End Property

Public Property Get EditingRecord() As Boolean
  EditingRecord = (mRs.EditMode <> adEditNone)
End Property

Public Property Get AbsolutePosition() As PositionEnum
  AbsolutePosition = mRs.AbsolutePosition
End Property

Public Sub AddNew()
  mRs.AddNew
End Sub

Public Sub Delete()
  mRs.Delete
    MoveNext
End Sub

Public Sub Requery()
  On Error GoTo error_Requery
  mRs.Requery
  DataMemberChanged "Primary"
  
  Exit Sub
error_Requery:
  MsgBox Err.Description, vbCritical

End Sub

Public Sub Update()

  On Error GoTo error_Update
  With mRs
    .UpdateBatch adAffectAll
    If .EditMode = adEditAdd Then
      MoveLast
    End If
  End With
  Exit Sub
error_Update:
  MsgBox Err.Description, vbCritical
  
End Sub

Public Sub Cancel()
  With mRs
    .CancelUpdate
    
    If Not .EOF And Not .BOF Then
        If .EditMode = adEditAdd Then
            MoveFirst
        End If
    End If
  End With
End Sub

Public Sub MoveFirst()
  If Not mRs.EOF Then
    mRs.MoveFirst
  End If
End Sub

Public Sub MoveLast()
    
  If Not mRs.EOF Then
    mRs.MoveLast
  End If
End Sub

Public Sub MoveNext()
  If Not mRs.EOF Then mRs.MoveNext
  If mRs.EOF And mRs.RecordCount > 0 Then
    Beep
    
    'ha sobrepasado el final; vuelva atrs
    mRs.MoveLast
  End If
End Sub

Public Sub MovePrevious()
  If Not mRs.BOF Then mRs.MovePrevious
  If mRs.BOF And mRs.RecordCount > 0 Then
    Beep
    
    'ha sobrepasado el final; vuelva atrs
    mRs.MoveFirst
  End If
End Sub

Private Sub Class_Terminate()
    On Local Error Resume Next
        
    mRs.Close
    Set mRs = Nothing
    DataMembers.Remove "Primary"
    
End Sub
