Attribute VB_Name = "Module1"
'Estructura NOTIFYICONDATA para usar con Shell_NotifyIcon
Public Type NOTIFYICONDATA
   cbSize As Long
   hwnd As Long
   uID As Long
   uFlags As Long
   uCallbackMessage As Long
   hIcon As Long
   szTip As String * 128
   dwState As Long
   dwStateMask As Long
   szInfo As String * 256
   uTimeout As Long
   szInfoTitle As String * 64
   dwInfoFlags As Long
End Type

'Variable para la estructura anterior
Public sysTray As NOTIFYICONDATA


'Constantes
Public Const NOTIFYICON_VERSION = 3
Public Const NOTIFYICON_OLDVERSION = 0

Public Const NIM_ADD = &H0  'Pone un icono en el systray
Public Const NIM_MODIFY = &H1  'Modifica el icono del systray
Public Const NIM_DELETE = &H2  'Quita el icono del systray

Public Const NIM_SETFOCUS = &H3
Public Const NIM_SETVERSION = &H4

Public Const NIF_MESSAGE = &H1
Public Const NIF_ICON = &H2
Public Const NIF_TIP = &H4

Public Const NIF_STATE = &H8
Public Const NIF_INFO = &H10

Public Const NIS_HIDDEN = &H1
Public Const NIS_SHAREDICON = &H2

Public Const NIIF_NONE = &H0  'No Muestra icono el el balon
Public Const NIIF_WARNING = &H2  'Muestra el icono de advertencia en el balon
Public Const NIIF_ERROR = &H3  'Muestra el icono de error en el balon
Public Const NIIF_INFO = &H1  'Muestra el icono de informacin en el balon
Public Const NIIF_GUID = &H4  'Muestra el icono que le marquemos

Public Const WM_MOUSEMOVE = &H200
Public Const WM_LBUTTONDOWN = &H201
Public Const WM_LBUTTONUP = &H202
Public Const WM_LBUTTONDBLCLK = &H203
Public Const WM_RBUTTONDOWN = &H204
Public Const WM_RBUTTONUP = &H205
Public Const WM_RBUTTONDBLCLK = &H206
 
' Declaracin Api
Public Declare Function Shell_NotifyIcon Lib "shell32" Alias "Shell_NotifyIconA" _
(ByVal dwMessage As Long, pnid As NOTIFYICONDATA) As Boolean

'Para que los controles tomen la apariencia de windows
Public Declare Function InitCommonControls Lib "comctl32.dll" () As Long

'Para poner el programa en Primer plano
Public Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Function GetWindowRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Public Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type
Public nWindow As RECT

'Funcin para poner el icono en el sistray
Public Sub PonerIcono(nForm As Form, nPic As PictureBox, nToolTipText As String)
 With sysTray
  .cbSize = Len(sysTray)
  .hwnd = nPic.hwnd
  .uID = vbNull
  .uFlags = NIF_ICON Or NIF_INFO Or NIF_MESSAGE Or NIF_TIP
  .uCallbackMessage = WM_MOUSEMOVE
  .hIcon = nPic.Picture
  .szTip = nToolTipText & vbNullChar 'ToolTipText del icono el el systrai
  .dwState = 0
  .dwStateMask = 0
 End With
   
 'Mostramos el icono en el systrai
 Shell_NotifyIcon NIM_ADD, sysTray
End Sub

'Para mostrar el globo en el icono del sistray
Public Sub MostrarGlobo(nForm As Form, nPic As PictureBox, nToolTipText As String, nTitulo As String, nDescrip As String)
 With sysTray
  .cbSize = Len(sysTray)
  .hwnd = nPic.hwnd
  .uID = vbNull
  .uFlags = NIF_ICON Or NIF_INFO Or NIF_MESSAGE Or NIF_TIP
  .uCallbackMessage = WM_MOUSEMOVE
  .hIcon = nPic
  .szTip = nToolTipText & vbNullChar 'ToolTipText del icono
  .dwState = 0
  .dwStateMask = 0
  .szInfoTitle = nTitulo & Chr(0) 'Este es el titulo del globo
  .szInfo = nDescrip & Chr(0) 'Este es el mensaje del globo
  .dwInfoFlags = NIIF_INFO
  .uTimeout = 5 'Tiempo que permanecera el globo visible
 End With
 
 'Modificamos el icono del systrai con la informacin
 Shell_NotifyIcon NIM_MODIFY, sysTray
End Sub

'Para eliminar el icono del sistray
Public Sub EliminarIcono()
 Shell_NotifyIcon NIM_DELETE, sysTray
End Sub

Public Function ControlDeErrores()
 If Err.Number <> 0 Then
  MsgBox "Error ocasionado por: " & Err.Description, vbCritical, "Error No. " & Err.Number
  Err.Clear
 End If
End Function
