VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   1440
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   6630
   LinkTopic       =   "Form1"
   ScaleHeight     =   1440
   ScaleWidth      =   6630
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "Capturar y guardar"
      Height          =   495
      Left            =   360
      TabIndex        =   0
      Top             =   240
      Width           =   3135
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

'-- Error handling definitions
Private Const E_ERR_BASE = 18020 + vbObjectError
Public Enum EErrScreenshot
    eESS_InvalidWindowHandle = E_ERR_BASE + 1
    eESS_InvalidCoordinates
    eESS_CantGetWindowRect
    eESS_NoActiveWindow
    eESS_ComponentFailure
End Enum
Private Const S_ERR_InvalidWindowHandle = "Invalid window handle"
Private Const S_ERR_InvalidCoordinates = "Invalid screen coordinates"
Private Const S_ERR_CantGetWindowRect = "Could not get window rect"
Private Const S_ERR_NoActiveWindow = "No active window for the calling thread"
Private Const S_ERR_ComponentFailure = "IAPP_Screenshot component failure"

Private Const CCHDEVICENAME = 32
Private Const CCHFORMNAME = 32
Private Const SRCCOPY = &HCC0020

Private Type DEVMODE
    dmDeviceName         As String * CCHDEVICENAME
    dmSpecVersion        As Integer
    dmDriverVersion      As Integer
    dmSize               As Integer
    dmDriverExtra        As Integer
    dmFields             As Long
    dmOrientation        As Integer
    dmPaperSize          As Integer
    dmPaperLength        As Integer
    dmPaperlWidth         As Integer
    dmScale              As Integer
    dmCopies             As Integer
    dmDefaultSource      As Integer
    dmPrintQuality       As Integer
    dmColor              As Integer
    dmDuplex             As Integer
    dmYResolution        As Integer
    dmTTOption           As Integer
    dmCollate            As Integer
    dmFormName           As String * CCHFORMNAME
    dmUnusedPadding      As Integer
    dmBitsPerPel         As Long
    dmPelslWidth          As Long
    dmPelslHeight         As Long
    dmDisplayFlags       As Long
    dmDisplayFrequency   As Long
End Type

Private Type RECT
    Left     As Long
    Top      As Long
    Right    As Long
    Bottom   As Long
End Type

Private Declare Function GetActiveWindow Lib "user32" () As Long
Private Declare Function GetDesktopWindow Lib "user32" () As Long
Private Declare Function GetWindowRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function IsWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetSystemMetrics Lib "user32" (ByVal nIndex As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal HDC As Long, ByVal hObject As Long) As Long
Private Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal HDC As Long) As Long
Private Declare Function OpenClipboard Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function EmptyClipboard Lib "user32" () As Long
Private Declare Function SetClipboardData Lib "user32" (ByVal wFormat As Long, ByVal hMem As Long) As Long
Private Declare Function CloseClipboard Lib "user32" () As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal HDC As Long) As Long
Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nlWidth As Long, ByVal nlHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function CreateDC Lib "gdi32" Alias "CreateDCA" (ByVal lpDriverName As String, ByVal lpDeviceName As String, ByVal lpOutput As String, lpInitData As DEVMODE) As Long
Private Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal HDC As Long, ByVal nlWidth As Long, ByVal nlHeight As Long) As Long
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal HDC As Long) As Long


Public Sub CaptureRectangle(Left As Long, Top As Long, lWidth As Long, lHeight As Long)
    On Error GoTo ehComponentFailure

    Dim DM          As DEVMODE
    Dim hBmpImage   As Long
    Dim lhDcSource   As Long
    Dim lhDcTarget   As Long

    If (Left < 0) Or (Top < 0) Or (lWidth > GetSystemMetrics(0)) Or (lHeight > GetSystemMetrics(1)) Then
        On Error GoTo 0
        Err.Raise eESS_InvalidCoordinates, App.EXEName & ".IAPP_Screenshot", S_ERR_InvalidCoordinates
    End If

    lhDcSource = CreateDC("DISPLAY", "", "", DM)
    lhDcTarget = CreateCompatibleDC(lhDcSource)

    hBmpImage = CreateCompatibleBitmap(lhDcSource, lWidth, lHeight)

    SelectObject lhDcTarget, hBmpImage
    BitBlt lhDcTarget, 0, 0, lWidth, lHeight, lhDcSource, Left, Top, SRCCOPY

    OpenClipboard 0&
    EmptyClipboard
    SetClipboardData 2, hBmpImage
    CloseClipboard

    DeleteDC lhDcTarget
    ReleaseDC hBmpImage, lhDcSource

    Exit Sub

ehComponentFailure:
    '-- Fail: Raise The Error
    Err.Raise eESS_ComponentFailure, App.EXEName & ".IAPP_Screenshot", S_ERR_ComponentFailure
End Sub

Private Sub Command1_Click()
    Call CaptureRectangle(0, 0, 250, 250)
    DoEvents
    
    With Clipboard
        If .GetFormat(vbCFBitmap) Then
            Call SavePicture(.GetData(vbCFBitmap), "c:\archivo.bmp")
            MsgBox "Ok .. imagen guardada en c:\archivo.bmp", vbInformation
        Else
            MsgBox "No hay imagen para guardar o la imagen no es vlida", vbCritical
        End If
    End With
End Sub

