Attribute VB_Name = "Module1"
 
Option Explicit
 
Private Declare Function StretchBlt _
    Lib "gdi32" ( _
    ByVal hdc As Long, _
    ByVal x As Long, _
    ByVal y As Long, _
    ByVal nWidth As Long, _
    ByVal nHeight As Long, _
    ByVal hSrcDC As Long, _
    ByVal xSrc As Long, _
    ByVal ySrc As Long, _
    ByVal nSrcWidth As Long, _
    ByVal nSrcHeight As Long, _
    ByVal dwRop As Long) As Long

Private Declare Function SetStretchBltMode _
    Lib "gdi32" ( _
    ByVal hdc As Long, _
    ByVal nStretchMode As Long) As Long

Private Declare Function CreateCompatibleDC _
    Lib "gdi32" ( _
    ByVal hdc As Long) As Long

Private Declare Function SelectObject _
    Lib "gdi32" ( _
    ByVal hdc As Long, _
    ByVal hObject As Long) As Long

Private Declare Function DeleteObject _
    Lib "gdi32" ( _
    ByVal hObject As Long) As Long

Private Declare Function DeleteDC _
    Lib "gdi32" ( _
    ByVal hdc As Long) As Long

Public Function ScaleImage(Img As StdPicture, Pic As PictureBox)

Dim PLeft As Long, PTop As Long
Dim ReqWidth As Long, ReqHeight As Long
Dim HScale As Double, VScale As Double
Dim MyScale As Double
Dim ImgWidth As Long
Dim ImgHeight As Long
Dim SourceHDC As Long

    With Pic
        .ScaleMode = vbPixels
        .AutoRedraw = True
        Pic.Cls

        ImgWidth = .ScaleX(Img.Width, vbHimetric, vbPixels)
        ImgHeight = .ScaleY(Img.Height, vbHimetric, vbPixels)
    
        HScale = .ScaleWidth / ImgWidth
        VScale = .ScaleHeight / ImgHeight

    End With
    
    MyScale = IIf(VScale >= HScale, HScale, VScale)
    
    ReqWidth = ImgWidth * MyScale
    ReqHeight = ImgHeight * MyScale
    
    
    PLeft = (Pic.ScaleWidth - ReqWidth) / 2
    PTop = (Pic.ScaleHeight - ReqHeight) / 2
      
    SourceHDC = CreateCompatibleDC(0)
    DeleteObject SelectObject(SourceHDC, Img.Handle)

    SetStretchBltMode Pic.hdc, vbPaletteModeNone

    If Img.Type = 3 Then
        Pic.PaintPicture Img, PLeft, PTop, ReqWidth, ReqHeight
    Else
        
        StretchBlt Pic.hdc, _
                   PLeft, _
                   PTop, _
                   ReqWidth, _
                   ReqHeight, _
                   SourceHDC, 0, 0, _
                   ImgWidth, ImgHeight, vbSrcCopy
   
        
        DeleteDC SourceHDC
    End If
    
End Function


