VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form Execute 
   Caption         =   "Execute 1.0"
   ClientHeight    =   4590
   ClientLeft      =   1140
   ClientTop       =   1500
   ClientWidth     =   5895
   Icon            =   "Execute.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   4590
   ScaleWidth      =   5895
   Begin VB.CheckBox chkDescargar 
      Caption         =   "Descargar el programa al ejecutar una aplicacin"
      Height          =   255
      Left            =   90
      TabIndex        =   14
      Top             =   4170
      Width           =   4395
   End
   Begin VB.CommandButton cmdSalir 
      Cancel          =   -1  'True
      Caption         =   "Salir"
      Height          =   345
      Left            =   4650
      TabIndex        =   13
      Top             =   4110
      Width           =   1125
   End
   Begin VB.CommandButton cmdExaminar 
      Caption         =   "Examinar..."
      Height          =   345
      Left            =   4650
      TabIndex        =   2
      Top             =   60
      Width           =   1125
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   90
      TabIndex        =   1
      Text            =   "Text1"
      Top             =   90
      Width           =   4455
   End
   Begin VB.CheckBox chkNoMostrar 
      Caption         =   "Al ejecutar, no mostrar el dilogo con ninguna extensin"
      Height          =   255
      Left            =   90
      TabIndex        =   0
      Top             =   3840
      Width           =   4395
   End
   Begin VB.PictureBox ContSolapa 
      BorderStyle     =   0  'None
      Height          =   2745
      Index           =   0
      Left            =   150
      ScaleHeight     =   2745
      ScaleWidth      =   5565
      TabIndex        =   4
      Top             =   870
      Width           =   5565
      Begin VB.CommandButton cmdExec 
         Caption         =   "Ejecutar"
         Default         =   -1  'True
         Height          =   345
         Left            =   4350
         TabIndex        =   12
         Top             =   2340
         Width           =   1125
      End
      Begin VB.ListBox List1 
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1740
         Left            =   60
         TabIndex        =   7
         Top             =   60
         Width           =   5415
      End
      Begin VB.CheckBox chkExtAuto 
         Caption         =   "Ejecutar automticamente con el programa seleccionado."
         Height          =   315
         Left            =   60
         TabIndex        =   6
         Top             =   1890
         Width           =   4425
      End
      Begin VB.CommandButton cmdGuardarSelec 
         Caption         =   "Guardar Seleccin"
         Height          =   345
         Left            =   2490
         TabIndex        =   5
         Top             =   2340
         Width           =   1725
      End
   End
   Begin VB.PictureBox ContSolapa 
      BorderStyle     =   0  'None
      Height          =   2745
      Index           =   1
      Left            =   150
      ScaleHeight     =   2745
      ScaleWidth      =   5565
      TabIndex        =   8
      Top             =   870
      Width           =   5565
      Begin VB.CommandButton cmdDesasociar 
         Caption         =   "Desasociar"
         Enabled         =   0   'False
         Height          =   345
         Left            =   4350
         TabIndex        =   11
         Top             =   2340
         Width           =   1125
      End
      Begin VB.CommandButton cmdAsociar 
         Caption         =   "Asociar"
         Enabled         =   0   'False
         Height          =   345
         Left            =   3120
         TabIndex        =   10
         Top             =   2340
         Width           =   1125
      End
      Begin VB.ListBox List2 
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   2160
         Left            =   60
         Sorted          =   -1  'True
         TabIndex        =   9
         Top             =   60
         Width           =   5415
      End
   End
   Begin ComctlLib.TabStrip TabStrip1 
      Height          =   3225
      Left            =   90
      TabIndex        =   3
      Top             =   510
      Width           =   5685
      _ExtentX        =   10028
      _ExtentY        =   5689
      _Version        =   327682
      BeginProperty Tabs {0713E432-850A-101B-AFC0-4210102A8DA7} 
         NumTabs         =   2
         BeginProperty Tab1 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "Programas Asociados"
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "Extensiones Registradas"
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   0
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      FontSize        =   2.12893e-38
   End
End
Attribute VB_Name = "Execute"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'---------------------------------------------------
'La utilidad de este programa es para
'asociar mltiples tipos de archivos,
'pudiendo seleccionar cualquiera de los asociados con la extensin,
'para que ejecute el fichero pasado como parmetro.
'
'Se puede asociar a cualquier extensin.
'Al ejecutarse un archivo asociado, se mostrarn
'los distintos ejecutables asociados a esa extensin,
'el archivo se ejecutar con el programa seleccionado.
'
'Tambin permite ejecutarlo automticamente con el ltimo
'programa seleccionado.
'
'Ejemplo con rutinas para el manejo del Registro del Sistema
'---------------------------------------------------
Option Explicit
Option Compare Text
'
'Variables y constantes usadas por el programa
Const gsIni = "Execute.ini"
Dim LineaComandos As String
Dim fPath As String
Dim fFile As String
Dim fName As String
Dim fExt As String
'Clase para los datos de las colecciones
Dim tAsoc As New cAsoc
'Coleccin para la extensin del archivo actual
Dim colAsoc As New Collection
'Coleccin para las extensiones registradas
Dim colExt As New Collection
'Flag para saber si la extensin actual est asociada a gsExecute
Dim EstaAsociada As Boolean
'Para descargar el programa al ejecutar una aplicacin
Dim DescargarPrograma As Boolean
'Valores para el tamao de la ventana
Dim iH As Integer
Dim iW As Integer
'Si ya hay una copia del programa...
Dim YaEstaCargado As Boolean
'
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Long) As Long

'Desglosa el parmetro en el path y el archivo
Private Sub SplitPathname(ByVal FullName As String, fPath As String, fFile As String)
    Dim i As Integer
    Dim p As Integer
    
    On Error Resume Next
    'Buscar el ltimo signo \
    For i = Len(FullName) To 1 Step -1
        If Mid$(FullName, i, 1) = "\" Then
            p = i - 1
            Exit For
        End If
    Next
    If p Then
        fPath = Left$(FullName, p)
    End If
    fFile = Right$(FullName, Len(FullName) - p)
End Sub

Private Sub cmdAsociar_Click()
    'Asociar esta extensin a gsExecute
    'Esta funcin asocia gsExecute con la extensin fExt y la asigna como programa por defecto
    'La descripcin ser: Ejecutar con gsExecute
    '
    Dim sProgId As String
    Dim sDef As String
    Dim hKey As Long
    Dim phkResult As Long
    Dim lRet As Long
    Dim sValue As String
    Dim sKey As String
    '
    'Buscar en el registro la extensin...
    sProgId = QueryRegBase("." & fExt)
    If Len(sProgId) Then
        'Nombre de la clave para esta extensin
        sDef = "Software\Classes\" & sProgId & "\shell"
        'usar HKEY_LOCAL_MACHINE, ya que HKEY_CLASSES_ROOT es una copia de: HKEY_LOCAL_MACHINE\Software\Classes
        hKey = HKEY_LOCAL_MACHINE
        'Crear la clave del registro, si ya existe, simplemente la abre.
        'Nota: Esta funcin permite crear varios niveles
        lRet = RegCreateKey(hKey, sDef, phkResult)
        If lRet = ERROR_SUCCESS Then
            'Si no hay error, la clave est creada y/o abierta
            '
            'Asignar los valores
            'NOTA: Si la clave no est creada, RegSetValue la crea.
            '
            sKey = "Ejecutar_con_Execute"
            sValue = "Ejecutar con Execute"
            lRet = RegSetValue(phkResult, sKey, REG_SZ, sValue, Len(sValue))
            '
            sKey = "Ejecutar_con_Execute\command"
            sValue = App.Path & "\" & App.EXEName & ".exe %1"
            lRet = RegSetValue(phkResult, sKey, REG_SZ, sValue, Len(sValue))
            '
            'Poner este prograna por defecto (asignarlo a Shell)
            sKey = ""
            sValue = "Ejecutar_con_Execute"
            'Si no se especifica sKey, se asigna a la clave abierta
            lRet = RegSetValue(phkResult, sKey, REG_SZ, sValue, Len(sValue))
            '
            'Cerrar la clave abierta
            lRet = RegCloseKey(phkResult)
        End If
    End If
End Sub

Private Sub cmdDesasociar_Click()
    'Quita la asociacin de esta extensin a gsExecute
    '
    Dim sProgId As String
    Dim sDef As String
    Dim hKey As Long
    Dim phkResult As Long
    Dim lRet As Long
    Dim sKey As String
    Dim sValue As String
    '
    'Buscar en el registro la extensin...
    sProgId = QueryRegBase("." & fExt)
    If Len(sProgId) Then
        'Nombre de la clave para esta extensin
        sDef = "Software\Classes\" & sProgId & "\shell"
        hKey = HKEY_LOCAL_MACHINE
        lRet = RegOpenKey(hKey, sDef, phkResult)
        If lRet = ERROR_SUCCESS Then
            'Si no hay error, la clave est abierta
            '
            sKey = "Ejecutar_con_gsExecute\command"
            lRet = RegDeleteKey(phkResult, sKey)
            '
            sKey = "Ejecutar_con_gsExecute"
            lRet = RegDeleteKey(phkResult, sKey)
            '
            'Poner este prograna por defecto (asignarlo a Shell)
            sKey = ""
            sValue = "open"
            'Si no se especifica sKey, se asigna a la clave abierta
            lRet = RegSetValue(phkResult, sKey, REG_SZ, sValue, Len(sValue))
            '
            'Cerrar la clave abierta
            lRet = RegCloseKey(phkResult)
        End If
    End If
End Sub


Private Sub cmdGuardarSelec_Click()
    Dim i As Integer
    
    'Guardar la configuracin para esta extensin
    If Len(fExt) Then
        SaveSetting gsIni, fExt, "CargarAuto", CStr(chkExtAuto.Value)
        i = List1.ListIndex + 1
        SaveSetting gsIni, fExt, "Programa", colAsoc(i).Exec
    End If
End Sub





Private Sub Form_Resize()
    If WindowState <> vbMinimized Then
        If Width <> iW Then Width = iW
        If Height <> iH Then Height = iH
    End If
End Sub

Private Sub List2_Click()
    'Asignar esta extensin
    Dim sKey As String
    Dim i As Integer
    Dim j As Integer
    
    If List2.ListCount > 0 Then
        i = List2.ListIndex
        j = InStr(List2.List(i), " (")
        If j Then
            sKey = Mid$(Left$(List2.List(i), j - 1), 2)
            LineaComandos = sKey
            Text1 = LineaComandos
            fExt = sKey
            EnumPrograms
        End If
        'Comprobar si ya est asociada a gsExecute
        If EstaAsociada Then
            cmdAsociar.Enabled = False
            cmdDesasociar.Enabled = True
        Else
            cmdAsociar.Enabled = True
            cmdDesasociar.Enabled = False
        End If
    End If
End Sub

Private Sub TabStrip1_Click()
    'mostrar el contenedor adecuado
    With TabStrip1.SelectedItem
        ContSolapa(.Index - 1).ZOrder
        If .Index = 2 Then
            'si no se han leido las extensiones...
            If List2.ListCount = 0 Then
                'Guardar copia de las extensiones registradas
                EnumExtensiones
            End If
        End If
    End With
End Sub


Private Sub CmdExaminar_Click()
    'Seleccionar el fichero a ejecutar
    Dim i As Integer
    Dim j As Integer
    Dim sTmp As String
    Dim sKey As String
    
    'Asignar las extensiones disponibles
    If List2.ListCount = 0 Then
        'Guardar copia de las extensiones registradas
        EnumExtensiones
    End If
    
    On Local Error Resume Next
    
    If Len(fPath) Then
        CommonDialog1.InitDir = fPath
    End If
    CommonDialog1.DialogTitle = "Ejecutar archivo"
    'Asignar aqu todas las extensiones registradas...
    'CommonDialog1.Filter = "Todos los archivos (*.*)|*.*"
    sTmp = "Todos los archivos (*.*)|*.*"
    'Tomar los datos segn el orden clasificado de List2
    For i = 0 To List2.ListCount - 1
        j = InStr(List2.List(i), " (")
        If j Then
            sKey = Left$(List2.List(i), j - 1)
            Set tAsoc = colExt(sKey)
            With tAsoc
                If Len(.Exec) Then
                    sTmp = sTmp & "|(*" & .Key & ") " & .Exec & "|*" & .Key
                End If
            End With
        End If
    Next
    CommonDialog1.Filter = sTmp
    sTmp = ""
    CommonDialog1.FilterIndex = 1
    CommonDialog1.CancelError = True
    CommonDialog1.ShowOpen
    If Err Then
        Err = 0
    Else
        LineaComandos = CommonDialog1.FileName
    End If
    'Descomponer la lnea de comandos en path, archivo, extensin...
    DesglosarNombre LineaComandos
    'La lnea de comandos tendr el archivo a abrir
    Text1 = LineaComandos
    'Mostrar los programas asociados a esta extensin
    EnumPrograms
End Sub

Private Sub cmdExec_Click()
    If List1.ListIndex >= 0 Then
        Ejecutar List1.ListIndex + 1
    End If
End Sub

Private Sub cmdSalir_Click()
    Unload Me
    End
End Sub

Private Sub Form_Load()
    Dim sProgId As String
    Dim sExec As String
    Dim res As Long
    Dim sDef As String
    '
    LineaComandos = Trim$(Command$)
    QuitarComillas LineaComandos
    '
    'Scroll Horizontal para los List
    Const LB_SETHORIZONTALEXTENT = &H400 + 21
    Const NULO = &O0
    Dim ListLen As Integer  'Ancho del List Box
    Dim iTmp As Long        'Para el valor devuelto por SendMessage
    Dim ScaleTmp As Integer 'Valor anterior de ScaleMode
    '
    ScaleTmp = ScaleMode
    ScaleMode = 3           'wParam siempre es en PIXEL
    ListLen = 1024
    iTmp = SendMessage(List1.hwnd, LB_SETHORIZONTALEXTENT, ListLen, NULO)
    iTmp = SendMessage(List2.hwnd, LB_SETHORIZONTALEXTENT, ListLen, NULO)
    ScaleMode = ScaleTmp    'Restablecer el valor anterior de ScaleMode
    '
    iH = Height
    iW = Width
    '
    'Si ya hay una copia del programa, descargarlo
    'despus de ejecutar la accin
    If App.PrevInstance Then
        YaEstaCargado = True
        chkNoMostrar.Value = 1
        chkDescargar.Value = 1
    Else
        YaEstaCargado = False
        chkNoMostrar.Value = Val(GetSetting(gsIni, "General", "CargarAuto", "0"))
        chkDescargar.Value = Val(GetSetting(gsIni, "General", "Descargar", "1"))
    End If
    '
    If Len(LineaComandos) = 0 Or InStr(LineaComandos, "/C") Then
        'mostrar directamente la configuracin
        LineaComandos = "Modo de Configuracin"
        fExt = ""
    Else
        'Descomponer la lnea de comandos en path, archivo, extensin...
        DesglosarNombre LineaComandos
    End If
    'La lnea de comandos tendr el archivo a abrir
    Text1 = LineaComandos
    If Len(fExt) Then
        ContSolapa(0).ZOrder
        'Mostrar los programas asociados a esta extensin
        EnumPrograms
        'Comprobar si hay que ejecutar directamente
        SeEjecuta
    Else
        Show
        DoEvents
        'Activar la solapa de configuracin
        TabStrip1.Tabs(2).Selected = True
        TabStrip1_Click
        'EnumExtensiones
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    If YaEstaCargado = False Then
        SaveSetting gsIni, "General", "CargarAuto", CStr(chkNoMostrar.Value)
        SaveSetting gsIni, "General", "Descargar", CStr(chkDescargar.Value)
    End If
    Set Execute = Nothing
End Sub

Private Sub EnumPrograms()
    'Lista los programas asociados a la extensin
    Dim sProgId As String
    Dim lRet As Long
    Dim L As Long
    Dim hKey As Long
    Dim phkResult As Long
    Dim sValue As String
    Dim sKey As String
    Dim sExec As String
    Dim i As Integer
    Dim sDef As String
    Dim j As Integer
    
    List1.Clear
    EstaAsociada = False
    'Buscar en el registro la extensin...
    sProgId = QueryRegBase("." & fExt)
    If Len(sProgId) Then
        'Programa asociado por defecto
        sDef = QueryRegBase(sProgId & "\shell")
        If sDef = "" Then sDef = "open"
        hKey = HKEY_CLASSES_ROOT
        'Abrir la clave del registro
        If RegOpenKey(hKey, sProgId & "\shell", phkResult) = ERROR_SUCCESS Then
            L = -1
            Do
                L = L + 1
                lRet = wRegEnumKey(phkResult, L, sValue)
                If lRet = ERROR_NO_MORE_ITEMS Then
                    Exit Do
                End If
                List1.AddItem sValue
            Loop
            lRet = RegCloseKey(phkResult)
            Set colAsoc = Nothing
            'Mostrar tambin los programas asociados
            For i = 0 To List1.ListCount - 1
                sKey = Trim$(List1.List(i))
                sExec = QueryRegBase(sProgId & "\shell\" & sKey & "\command")
                Set tAsoc = Nothing
                With tAsoc
                    .Key = sKey
                    .Exec = sExec
                    colAsoc.Add tAsoc
                    If InStr(sKey, "gsExecute") Then
                        EstaAsociada = True
                    End If
                End With
            Next
            List1.Clear
            i = -1
            j = 0
            For Each tAsoc In colAsoc
                With tAsoc
                    List1.AddItem .Key & " (" & .Exec & ")"
                    'Para resaltar el programa seleccionado por defecto
                    i = i + 1
                    If .Key = sDef Then
                        j = i
                    End If
                End With
            Next
            List1.ListIndex = j
            SeEjecuta False
        Else
            List1.AddItem "ERROR: No se ha podido abrir la clave del registro."
        End If
    Else
        List1.AddItem "No hay programas asociados a la extensin: " & fExt
    End If
End Sub

Private Sub Ejecutar(Indice As Variant)
    Dim lRet As Long
    Dim sExec As String
    
    'Ejecutar el programa pasado cmo parmetro
    If Val(Indice) Then
        sExec = colAsoc(Indice).Exec
    Else
        sExec = Indice
    End If
    If Len(sExec) Then
        If InStr(sExec, Chr$(34) & "%1" & Chr$(34)) Then
            sExec = ReplaceStringPart(sExec, Chr$(34) & "%1" & Chr$(34), LineaComandos)
        Else
            sExec = ReplaceStringPart(sExec, "%1", LineaComandos)
        End If
        'MsgBox "Se va a ejecutar el siguiente comando:" & vbCrLf & sExec
        On Local Error Resume Next
        lRet = Shell(sExec, 1)
        If Err = 0 Then
            'Slo descargar el programa si est seleccionada la opcin
            If chkDescargar.Value Then
                Unload Me
                End
            Else
                'sino minimizar la ventana
                WindowState = vbMinimized
            End If
        End If
        On Local Error GoTo 0
    Else
        MsgBox "No hay programa asociado para ejecutar con la extensin " & fExt
    End If
End Sub

'Busca en source cada coincidencia de src y la reemplaza por el contenido de rpl
'Devuelve la cadena resultante
Private Function ReplaceStringPart(ByVal source As String, ByVal src As String, ByVal rpl As String) As String
    Dim pos&
    On Error Resume Next
    src = UCase$(src)
    pos = InStr(UCase$(source), src)
    If src <> UCase$(rpl) Then
        Do While pos
            source = Left$(source, pos - 1) & rpl & Right$(source, Len(source) - pos - Len(src) + 1)
            pos = InStr(pos + Len(rpl), UCase$(source), src)
        Loop
    End If
    ReplaceStringPart = source
End Function

Private Sub List1_DblClick()
    If List1.ListIndex >= 0 Then
        Ejecutar List1.ListIndex + 1
    End If
End Sub

Private Sub EnumExtensiones()
    'guardar lista de las extensiones registradas
    Dim hKey As Long
    Dim i As Long
    Dim sValue As String
    Dim lRet As Long
    Dim sKey As String
    Dim sExec As String
    Dim sClave As String
    
    Text1 = "Cargando las extensiones, un momento..."
    DoEvents
    HabilitarControles False
    List2.Clear
    Set colExt = Nothing
    hKey = HKEY_CLASSES_ROOT
    i = -1
    Do
        i = i + 1
        lRet = wRegEnumKey(hKey, i, sValue)
        If lRet = ERROR_NO_MORE_ITEMS Then
            Exit Do
        End If
        'Guardar slo las extensiones
        If Left$(sValue, 1) = "." Then
            Set tAsoc = Nothing
            tAsoc.Key = sValue
            tAsoc.Exec = ""
            colExt.Add tAsoc, tAsoc.Key
        End If
    Loop
    For Each tAsoc In colExt
        With tAsoc
            sValue = .Key
            sExec = QueryRegBase(sValue)
            If Len(sExec) Then
                .Exec = sExec
                List2.AddItem .Key & " (" & .Exec & ")"
            End If
        End With
    Next
    HabilitarControles True
    Text1 = LineaComandos
    DoEvents
End Sub

Private Sub SeEjecuta(Optional Modo)
    'Comprobar si hay que ejecutar directamente o mostrar el dilogo
    Dim sExec As String
    Dim i As Integer
    Dim j As Integer
    Dim bModo As Boolean
    
    If IsMissing(Modo) Then
        bModo = True
    Else
        bModo = CBool(Modo)
    End If
    'leer la configuracin para la extensin...
    chkExtAuto.Value = Val(GetSetting(gsIni, fExt, "CargarAuto", "0"))
    sExec = GetSetting(gsIni, fExt, "Programa", "")
    'Resaltar el programa seleccionado
    j = 0
    i = -1
    For Each tAsoc In colAsoc
        i = i + 1
        If tAsoc.Exec = sExec Then
            j = i
            Exit For
        End If
    Next
    List1.ListIndex = j
    If bModo Then
        If chkExtAuto.Value Then
            'Cargar el programa
            Ejecutar sExec
        End If
    End If
End Sub

Private Sub HabilitarControles(Modo As Boolean)
    'Habilitar o deshabilitar los controles
    Dim Control As Control
    
    On Local Error Resume Next
    
    For Each Control In Me.Controls
        Control.Enabled = Modo
    Next
    On Local Error GoTo 0
End Sub


'Desglosa el archivo en nombre y  extensin
Private Sub SplitFilename(ByVal fFile As String, fName As String, fExt As String)
    Dim p As Integer
    
    On Error Resume Next
    p = InStr(fFile, ".")
    If p Then
        fName = Left$(fFile, p - 1)
        fExt = Mid$(fFile, p + 1, Len(fFile) - p)
    Else
        fName = fFile
        fExt = ""
    End If
End Sub

'Busca una entrada en el registro
Private Function QueryRegBase(ByVal Entry As String, Optional vKey) As String
    Dim buf As String
    Dim buflen As Long
    Dim hKey As Long
    
    If IsMissing(vKey) Then
        hKey = HKEY_CLASSES_ROOT
    Else
        hKey = CLng(vKey)
    End If
    
    On Local Error Resume Next
    buf = Space$(300)
    buflen = Len(buf)
    'Buscar la entrada especificada y devolver el valor asignado
    If RegQueryValue(hKey, Entry, buf, buflen) = 0 Then
        If buflen > 1 Then
            'El formato devuelto es ASCIIZ, as que quitar el ltimo caracter
            QueryRegBase = Left$(buf, buflen - 1)
        Else
            QueryRegBase = ""
        End If
    Else
        QueryRegBase = ""
    End If
    On Local Error GoTo 0
End Function


'Warp para RegEnumKey
Private Function wRegEnumKey(ByVal hKey As Long, ByVal L As Long, strKeyName As String) As Long
    Dim strResult As String
    
    strResult = String(300, " ")
    wRegEnumKey = RegEnumKey(hKey, L, strResult, Len(strResult))
    If InStr(strResult, Chr$(0)) Then
        strKeyName = Left$(strResult, InStr(strResult, Chr$(0)) - 1)
    Else
        strKeyName = Trim$(strResult)
    End If
End Function


Private Sub DesglosarNombre(sNombre As String)
    'La lnea de comandos tendr el archivo a abrir
    LineaComandos = Trim$(sNombre)
    'Por si el parmetro incluye comillas
    QuitarComillas LineaComandos
    'Desglosarla para obtener: el path, el nombre y la extensin
    SplitPathname LineaComandos, fPath, fFile
    SplitFilename fFile, fName, fExt
End Sub



Private Sub QuitarComillas(sCadena As String)
    'Quitar las comillas, si hay de la lnea de comandos
    sCadena = Trim$(sCadena)
    If Left$(sCadena, 1) = Chr$(34) Then
        sCadena = LTrim$(Mid$(sCadena, 2))
    End If
    If Right$(sCadena, 1) = Chr$(34) Then
        sCadena = RTrim$(Left$(sCadena, Len(sCadena) - 1))
    End If
End Sub
