VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Cambiar Resolucion"
   ClientHeight    =   2685
   ClientLeft      =   5610
   ClientTop       =   2880
   ClientWidth     =   3840
   Icon            =   "Cambia_Res.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2685
   ScaleWidth      =   3840
   StartUpPosition =   2  'CenterScreen
   Begin VB.OptionButton optShut 
      Caption         =   "Forzado"
      Height          =   255
      Index           =   3
      Left            =   2160
      TabIndex        =   9
      Top             =   1320
      Width           =   1335
   End
   Begin VB.OptionButton optShut 
      Caption         =   "Apagar"
      Height          =   255
      Index           =   2
      Left            =   2160
      TabIndex        =   8
      Top             =   960
      Width           =   1215
   End
   Begin VB.OptionButton optShut 
      Caption         =   "Reiniciar"
      Height          =   255
      Index           =   1
      Left            =   2160
      TabIndex        =   7
      Top             =   600
      Width           =   975
   End
   Begin VB.OptionButton optShut 
      Caption         =   "Cambio Usuario"
      Height          =   255
      Index           =   0
      Left            =   2160
      TabIndex        =   6
      Top             =   240
      Width           =   1575
   End
   Begin VB.CommandButton cmdReboot 
      Caption         =   "&Reiniciar Pc"
      Height          =   375
      Left            =   2160
      TabIndex        =   5
      Top             =   1680
      Width           =   1455
   End
   Begin VB.OptionButton optRes 
      Caption         =   "1024 x 768"
      Height          =   195
      Index           =   2
      Left            =   480
      TabIndex        =   4
      Top             =   960
      Value           =   -1  'True
      Width           =   1215
   End
   Begin VB.OptionButton optRes 
      Caption         =   "800 x 600"
      Height          =   195
      Index           =   1
      Left            =   480
      TabIndex        =   3
      Top             =   600
      Width           =   1455
   End
   Begin VB.OptionButton optRes 
      Caption         =   "640 x 480"
      Height          =   195
      Index           =   0
      Left            =   480
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
   Begin VB.CommandButton cmdQuit 
      Caption         =   "&Salir"
      Height          =   375
      Left            =   2160
      TabIndex        =   1
      Top             =   2160
      Width           =   1455
   End
   Begin VB.CommandButton cmdChange 
      Caption         =   "&Cambiar Resolucion"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   1680
      Width           =   1695
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim bWindowsNT As Boolean
'
' Conatantes del sistema operativo
'
Const VER_PLATFORM_WIN32s = 0
Const VER_PLATFORM_WIN32_WINDOWS = 1
Const VER_PLATFORM_WIN32_NT = 2

Private Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion      As Long
    dwMinorVersion      As Long
    dwBuildNumber       As Long
    dwPlatformId        As Long
    szCSDVersion        As String * 128
End Type

Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" (lpVersionInformation As OSVERSIONINFO) As Long
'
' Constantes de Reinicio/Cambio de resolucin
'
Const EWX_LOGOFF = 0
Const EWX_SHUTDOWN = 1
Const EWX_REBOOT = 2
'
' Usando esta opcin para reiniciar no se envian los mensajes
' WM_QUERYENDSESSION y WM_ENDSESSION a la aplicaciones abiertas
' Asi pues muchas aplicaciones perderan los datos que no se han salvado
'
Const EWX_FORCE = 4
Const CCDEVICENAME = 32
Const CCFORMNAME = 32
Const DM_BITSPERPEL = &H40000
Const DM_PELSWIDTH = &H80000
Const DM_PELSHEIGHT = &H100000
Const CDS_UPDATEREGISTRY = &H1
Const CDS_TEST = &H4
Const DISP_CHANGE_SUCCESSFUL = 0
Const DISP_CHANGE_RESTART = 1
 
Const HWND_BROADCAST = &HFFFF&
Const WM_DISPLAYCHANGE = &H7E&
Const SPI_SETNONCLIENTMETRICS = 42

Private Type DEVMODE
    dmDeviceName       As String * CCDEVICENAME
    dmSpecVersion      As Integer
    dmDriverVersion    As Integer
    dmSize             As Integer
    dmDriverExtra      As Integer
    dmFields           As Long
    dmOrientation      As Integer
    dmPaperSize        As Integer
    dmPaperLength      As Integer
    dmPaperWidth       As Integer
    dmScale            As Integer
    dmCopies           As Integer
    dmDefaultSource    As Integer
    dmPrintQuality     As Integer
    dmColor            As Integer
    dmDuplex           As Integer
    dmYResolution      As Integer
    dmTTOption         As Integer
    dmCollate          As Integer
    dmFormName         As String * CCFORMNAME
    dmUnusedPadding    As Integer
    dmBitsPerPel       As Integer
    dmPelsWidth        As Long
    dmPelsHeight       As Long
    dmDisplayFlags     As Long
    dmDisplayFrequency As Long
End Type

Private Declare Function EnumDisplaySettings Lib "user32" Alias "EnumDisplaySettingsA" (ByVal lpszDeviceName As Long, ByVal iModeNum As Long, lpDevMode As Any) As Boolean
Private Declare Function ChangeDisplaySettings Lib "user32" Alias "ChangeDisplaySettingsA" (lpDevMode As Any, ByVal dwFlags As Long) As Long
Private Declare Function ExitWindowsEx Lib "user32" (ByVal uFlags As Long, ByVal dwReserved As Long) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
'
' Las siguientes constantes son utilizadas para apagar NT.
'
Const ERROR_NOT_ALL_ASSIGNED = 1300
Const SE_PRIVILEGE_ENABLED = 2
Const TOKEN_QUERY = &H8
Const TOKEN_ADJUST_PRIVILEGES = &H20

Private Type LUID
    lowpart As Long
    highpart As Long
End Type

Private Type LUID_AND_ATTRIBUTES
    pLuid As LUID
    Attributes As Long
End Type

Private Type TOKEN_PRIVILEGES
    PrivilegeCount As Long
    Privileges As LUID_AND_ATTRIBUTES
End Type

Private Declare Function AdjustTokenPrivileges Lib "advapi32.dll" (ByVal TokenHandle As Long, ByVal DisableAllPriv As Long, NewState As TOKEN_PRIVILEGES, ByVal BufferLength As Long, PreviousState As TOKEN_PRIVILEGES, ReturnLength As Long) As Long
Private Declare Function LookupPrivilegeValue Lib "advapi32.dll" Alias "LookupPrivilegeValueA" (ByVal lpSystemName As Any, ByVal lpName As String, lpUid As LUID) As Long
Private Declare Function OpenProcessToken Lib "advapi32.dll" (ByVal ProcessHandle As Long, ByVal DesiredAccess As Long, TokenHandle As Long) As Long
Private Declare Function GetCurrentProcess Lib "kernel32" () As Long

Private Sub cmdQuit_Click()
End
End Sub

Private Sub cmdChange_Click()
Dim DevM    As DEVMODE
Dim lResult As Long
Dim iAns    As Integer
'
'Pilla la informacin de los modos graficos actuales

lResult = EnumDisplaySettings(0, 0, DevM)
'Pone la nueva resolucin
'No cambia la profundidad del color
'
With DevM
    .dmFields = DM_PELSWIDTH Or DM_PELSHEIGHT 'o DM_BITSPERPEL
    If optRes(0) Then
        .dmPelsWidth = 640  'ScreenWidth
        .dmPelsHeight = 480 'ScreenHeight
    ElseIf optRes(1) Then
        .dmPelsWidth = 800
        .dmPelsHeight = 600
    Else
        .dmPelsWidth = 1024
        .dmPelsHeight = 768
    End If
    '.dmBitsPerPel = 32 (puede ser 8, 16, 32)
End With
'Ya lo tenemos en la variable
'Lo cambiamos.
lResult = ChangeDisplaySettings(DevM, CDS_TEST)

'Veamos que dice el sistema
Select Case lResult
    Case DISP_CHANGE_RESTART
        iAns = MsgBox("Debes de reiniciar el ordenador para que tengan  efecto los cambios." & _
            vbCrLf & vbCrLf & "Quieres reiniciar ahora?", _
            vbYesNo + vbSystemModal, "Resolucion de pantalla")
        If iAns = vbYes Then Call ExitWindowsEx(EWX_REBOOT, 0)
    Case DISP_CHANGE_SUCCESSFUL
        Call ChangeDisplaySettings(DevM, CDS_UPDATEREGISTRY)
        Call SendMessage(HWND_BROADCAST, WM_DISPLAYCHANGE, SPI_SETNONCLIENTMETRICS, ByVal 0&)
        MsgBox "Resolucion de pantalla cambiada", vbInformation, "Resolucion Cambiada"
    Case Else
        MsgBox "Modo no soportado", vbSystemModal, "Error"
End Select
End Sub


Private Sub cmdReboot_Click()
Dim tLuid          As LUID
Dim tTokenPriv     As TOKEN_PRIVILEGES
Dim tPrevTokenPriv As TOKEN_PRIVILEGES
Dim lResult        As Long
Dim lToken         As Long
Dim lLenBuffer     As Long
Dim lMode As Long
'
' Determinar el modo de reiniciar.
'
' EWX_LOGOFF
'   Termina todos los procesos que se esten ejecutando y
'   desconecta al usuario.
'
' EWX_REBOOT
'   Apaga y reinicia el sistema.
'
' EWX_SHUTDOWN
'   Apaga el sistema en un punto donde es seguro.
'
' EWX_POWEROFF
'   Apaga el sistema y quita la corriente.
'   Si el sistema tiene esta caracteristica.
'
' EWX_FORCE
'   Se fuerza a apagar el sistema. Los ficheros no son cerrados,...
'   los datos se pueden perder.
'
If optShut(0) Then
    lMode = EWX_LOGOFF
ElseIf optShut(1) Then
    lMode = EWX_REBOOT
ElseIf optShut(2) Then
    lMode = EWX_SHUTDOWN
Else: lMode = EWX_FORCE
End If

If Not bWindowsNT Then
    Call ExitWindowsEx(lMode, 0)
Else
    '
    ' pilla el access token del proceso actual. Pilla
    ' los privilegios de la cola del access token y
    ' ajusta estos privilegios.
    '
    lResult = OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES Or TOKEN_QUERY, lToken)
    If lResult = 0 Then
        Exit Sub 'Fallo
    End If
    '
    ' Pilla el IDentificador Unico Local (LUID) el cual
    ' representa los provilegios de shutdown.
    '
    lResult = LookupPrivilegeValue(0&, "SeShutdownPrivilege", tLuid)
    If lResult = 0 Then Exit Sub 'Fallo
    '
    ' Pone los nuevos valores del TOKEN_PRIVILEGES  con el  LUID
    ' and allow your current process to shutdown the computer.
    '
    With tTokenPriv
        .PrivilegeCount = 1
        .Privileges.Attributes = SE_PRIVILEGE_ENABLED
        .Privileges.pLuid = tLuid
    lResult = AdjustTokenPrivileges(lToken, False, tTokenPriv, Len(tPrevTokenPriv), tPrevTokenPriv, lLenBuffer)
    End With
    
    If lResult = 0 Then
        Exit Sub 'Fallo
    Else
        If Err.LastDllError = ERROR_NOT_ALL_ASSIGNED Then Exit Sub 'Fallo
    End If
    '
    '  Shutdown Windows.
    '
    Call ExitWindowsEx(lMode, 0)
End If
End Sub




Private Sub Form_Load()
Dim OSInfo As OSVERSIONINFO
'
' Mira a ver si se esta ejecuntando windows9x o NT.
'
OSInfo.dwOSVersionInfoSize = Len(OSInfo)
Call GetVersionEx(OSInfo)
bWindowsNT = (OSInfo.dwPlatformId = VER_PLATFORM_WIN32_NT)
End Sub


Private Sub Form_Resize()
On Error Resume Next
Move (Screen.Width - Me.Width) / 29, (Screen.Height - Me.Height) / 29

End Sub

Private Sub Form_Unload(Cancel As Integer)
End
End Sub
