Attribute VB_Name = "Module1"
Public Function PrintText(TextBox As Control, _
                          ByVal LeftMargin As Double, _
                          ByVal RightMargin As Double, _
                          ByVal TopMargin As Double, _
                          ByVal BottomMargin As Double, _
                          ByVal PrintSelectedOnly As Boolean) As Boolean
    
    Dim PrintAreaWidth#
    Dim StartPara&, EndPara&
    Dim SpaceFound&, TabFound&, TryBreak&, LineBreak&
    Dim TextToPrint$, ParaText$, PrintLine$
    

    On Error GoTo PrintText_Err
    

    TextToPrint$ = IIf(PrintSelectedOnly, TextBox.SelText, TextBox.Text)
    If TextToPrint$ = "" Then Exit Function
    

    PrintAreaWidth# = Printer.ScaleWidth - LeftMargin - RightMargin
    
    If PrintAreaWidth# <= 0 Then Exit Function
    If Printer.ScaleHeight - TopMargin - BottomMargin <= 0 Then Exit Function
    

    Printer.Font.Name = TextBox.Font.Name
    Printer.Font.Bold = TextBox.Font.Bold
    Printer.Font.Charset = TextBox.Font.Charset
    Printer.Font.Italic = TextBox.Font.Italic
    Printer.Font.Size = TextBox.Font.Size
    Printer.Font.Strikethrough = TextBox.Font.Strikethrough
    Printer.Font.Underline = TextBox.Font.Underline
    Printer.Font.Weight = TextBox.Font.Weight
    
    If Printer.CurrentY < TopMargin Then Printer.CurrentY = TopMargin
    
    StartPara& = 1
    Do

        EndPara& = InStr(StartPara&, TextToPrint$, vbCrLf)
        If EndPara& = 0 Then EndPara& = Len(TextToPrint$) + 1
        ParaText$ = Mid$(TextToPrint$, StartPara&, EndPara& - StartPara&)
        
        Do
            If ParaText$ <> "" Then
                TryBreak& = 0
                LineBreak& = 0
                Do
                    SpaceFound& = InStr(TryBreak& + 1, ParaText$, " ")
                    TabFound& = InStr(TryBreak& + 1, ParaText$, vbTab)
                    TryBreak& = IIf(TabFound& > 0 And TabFound& < SpaceFound&, TabFound&, SpaceFound&)
                    If TryBreak& = 0 Then TryBreak& = Len(ParaText$) + 1
                    If Printer.TextWidth(Left$(ParaText$, TryBreak& - 1)) <= PrintAreaWidth# Then
                        LineBreak& = TryBreak&
                    Else
                        Exit Do
                    End If
                Loop Until TryBreak& > Len(ParaText$)
                
                If LineBreak& = 0 Then
                    For TryBreak& = 1 To Len(ParaText$)
                        If Printer.TextWidth(Left$(ParaText$, TryBreak& - 1)) > PrintAreaWidth# Then
                            LineBreak& = TryBreak& - 1
                            Exit For
                        End If
                    Next TryBreak&
                    If LineBreak& = 0 Then LineBreak& = 1
                End If
                
                PrintLine$ = Left$(ParaText$, LineBreak&)
                If LineBreak& > Len(ParaText$) Then
                    ParaText$ = ""
                Else
                    ParaText$ = LTrim$(Mid$(ParaText$, LineBreak&))
                End If
            Else
                PrintLine$ = ""
            End If
                        

            If Printer.CurrentY + Printer.TextHeight(PrintLine$) > Printer.ScaleHeight - BottomMargin Then
                Printer.NewPage
                Printer.CurrentY = TopMargin
            End If
            
            Select Case TextBox.Alignment
                Case vbLeftJustify
                    Printer.CurrentX = LeftMargin
                Case vbRightJustify
                    Printer.CurrentX = Printer.ScaleWidth - RightMargin - Printer.TextWidth(PrintLine$)
                Case vbCenter
                    Printer.CurrentX = LeftMargin + (PrintAreaWidth# - Printer.TextWidth(PrintLine$)) / 2
            End Select
            

            Printer.Print PrintLine$
    
        Loop Until ParaText$ = ""
        
        StartPara& = EndPara& + 2
    Loop Until EndPara& > Len(TextToPrint$)


    Printer.EndDoc
    PrintText = True

PrintText_Err:
End Function

