VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Informacin de la CPU - WMI Demo "
   ClientHeight    =   4905
   ClientLeft      =   2415
   ClientTop       =   1845
   ClientWidth     =   6795
   ClipControls    =   0   'False
   LinkTopic       =   "Form1"
   ScaleHeight     =   4905
   ScaleWidth      =   6795
   Begin VB.TextBox txtCpu 
      Height          =   2715
      Left            =   240
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      TabIndex        =   2
      Top             =   2040
      Width           =   5745
   End
   Begin VB.ListBox lstCPU 
      Height          =   645
      Left            =   240
      TabIndex        =   0
      Top             =   1080
      Width           =   4020
   End
   Begin VB.Label lblInfo 
      AutoSize        =   -1  'True
      Caption         =   "Information for Selected CPU"
      Height          =   195
      Left            =   240
      TabIndex        =   4
      Top             =   1800
      Width           =   2055
   End
   Begin VB.Label lblTitle 
      AutoSize        =   -1  'True
      Caption         =   "Label1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   240
      TabIndex        =   3
      Top             =   210
      Width           =   615
   End
   Begin VB.Label lblCPUList 
      AutoSize        =   -1  'True
      Caption         =   "CPUs"
      Height          =   195
      Left            =   240
      TabIndex        =   1
      Top             =   720
      Width           =   405
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'***********************************************************\
'NOTES:

'YOU MUST HAVE WMI SDK INSTALLED.  YOU CAN GET IT AT
'http://msdn.microsoft.com/downloads/sdks/wmi/default.asp
'***********************************************************************

Private asCpuPaths() As String
Private m_objCPUSet As SWbemObjectSet
Private m_objWMINameSpace As SWbemServices
Option Explicit

Private Sub cmdDone_Click()
Unload Me
End Sub

Private Sub Form_Load()


Dim oCpu As SWbemObject 'WMI Object, in this case, local CPUs
Dim sPath As String, sCaption As String

Dim lElement As Long
ReDim asCpuPaths(0) As String


On Error GoTo ErrorHandler

'Get Default NameSpace, which will be the one for the local machine
Me.Move (Screen.Width - Me.Width) / 2, (Screen.Height - Me.Height) / 2
Set m_objWMINameSpace = GetObject("winmgmts:")
lstCPU.Clear


'Get CPU set

Set m_objCPUSet = m_objWMINameSpace.InstancesOf("Win32_Processor")
sCaption = m_objCPUSet.Count & " processor"
If m_objCPUSet.Count <> 1 Then sCaption = sCaption & "s"
sCaption = sCaption & " detected on this machine"
lblTitle.Caption = sCaption
'Populate list box with CPU names
                
For Each oCpu In m_objCPUSet
     With oCpu
        sPath = .Path_ & ""
            If sPath <> "" Then
                lstCPU.AddItem .Name
                'save path to array, so on machines with multiple CPUs,
                'each can be identified and their info loaded into text box
                
                lElement = IIf(asCpuPaths(0) = "", 0, UBound(asCpuPaths) + 1)
                ReDim Preserve asCpuPaths(lElement) As String
                asCpuPaths(lElement) = sPath
            End If
     End With
Next
If lstCPU.ListCount <> 0 Then lstCPU.ListIndex = 0
     
 



CleanUp:
Set oCpu = Nothing

Exit Sub

ErrorHandler:
MsgBox "CPU Information could not be displayed due to the following error: " & Err.Description, , "WMI Demo Failed"
GoTo CleanUp
End Sub

Private Sub Form_Unload(Cancel As Integer)
Set m_objCPUSet = Nothing
Set m_objWMINameSpace = Nothing
End Sub

Private Sub lstCPU_Click()
Dim oCpu As SWbemObject
'Refer to SDK documentation for more detail about each of these properties
Dim sInfoString As String
On Error Resume Next
Set oCpu = m_objCPUSet(asCpuPaths(lstCPU.ListIndex))
With oCpu
    sInfoString = "Description: " & .Description & vbCrLf
    sInfoString = sInfoString & "Processor ID: " & .ProcessorID & vbCrLf
    sInfoString = sInfoString & "Status: " & .Status & vbCrLf
    sInfoString = sInfoString & "Manufacturer: " & .Manufacturer & vbCrLf
    sInfoString = sInfoString & "Availability: " & AvailabilityToString(.Availability) & vbCrLf
    sInfoString = sInfoString & "Load Percentage: " & .LoadPercentage & vbCrLf
    sInfoString = sInfoString & "Current Clock Speed: " & .CurrentClockSpeed & " MHz" & vbCrLf
    sInfoString = sInfoString & "Maximum Clock Speed: " & .MaxClockSpeed & vbCrLf
    sInfoString = sInfoString & "Level 2 Cache Size: " & .L2CacheSize & vbCrLf
    sInfoString = sInfoString & "Level 2 Cache Speed: " & .L2CacheSpeed & vbCrLf
    sInfoString = sInfoString & "Power Management Supported: " & .PowerManagementSupported
End With
txtCpu.Text = sInfoString

End Sub
'Conversions from code to string were developed
'based on information in WMI SDK documentation
Private Function AvailabilityToString(Code As Integer) As String
Dim sAns As String

Select Case Code
    Case 1, 2
        sAns = "Unknown"
    Case 3
        sAns = "Running/Full Power"
    Case 4
        sAns = "Warning"
    Case 5
        sAns = "In Test"
    Case 6
        sAns = "Not Applicable"
    Case 7
        sAns = "Power Off"
    Case 8
        sAns = "Off Line"
    Case 9
        sAns = "Off Duty"
    Case 10
        sAns = "Degraded"
    Case 11
        sAns = "Not Installed"
    Case 12
        sAns = "Install Error"
    Case 13
        sAns = "Power Save - Unknown"
    Case 14
        sAns = "Power Save - Low Power Mode"
    Case 15
        sAns = "Power Save - Standby"
    Case 16
        sAns = "Power Cycle"
    Case 17
        sAns = "Power Save - Warning"
    Case Else
        sAns = "Unknown"
End Select
AvailabilityToString = sAns

End Function


        

