Attribute VB_Name = "Module1"
Option Explicit
Function ExportarExcel(FlexGrid As Object, _
                      sql As String, _
                      cn As ADODB.Connection) As String

Dim rs As ADODB.Recordset

Dim ObjExcel As Excel.Application
Dim Libro As Excel.Workbook
Dim Hoja As Excel.Worksheet

Dim ObjField As Field
Dim i As Integer
Dim c As Integer
                
    Set rs = New ADODB.Recordset
    Screen.MousePointer = vbHourglass
    With rs
        .CursorLocation = adUseClient
        .Open sql, cn, 2, 3
    End With
    
    Set ObjExcel = New Excel.Application
    Set Libro = ObjExcel.Workbooks.Add
    Set Hoja = Libro.Sheets(1)
    
    With Hoja
    .Cells.Clear
    c = 1
    
    For Each ObjField In rs.Fields
        .Cells(1, c) = ObjField.Name
        c = c + 1
    Next

    If rs.RecordCount > 0 Then
        rs.MoveLast
        rs.MoveFirst
        For i = 1 To rs.RecordCount
            c = 1
            For Each ObjField In rs.Fields
                .Cells(i + 1, c) = rs.Fields(ObjField.Name)
                c = c + 1
            Next
            rs.MoveNext
        Next i
    End If
End With
    
    With Hoja
        .Cells.Select
        Libro.Application.Selection.Columns.AutoFit
        
        .Rows("1:1").Select
    
    
    With Libro.Application.Selection
        .HorizontalAlignment = xlGeneral
        .VerticalAlignment = xlCenter
        .WrapText = False
        .Orientation = 0
        .AddIndent = False
        .ShrinkToFit = False
        .MergeCells = False
    End With
    
    With Libro.Application.Selection.Font
        .Name = "Verdana"
        .Size = 12
        .Strikethrough = False
        .Superscript = False
        .Subscript = False
        .OutlineFont = False
        .Shadow = False
        .Underline = xlUnderlineStyleNone
        .ColorIndex = 47
    End With
    
    .Rows("1:1").RowHeight = 30
    .Range("A1").Select
    End With
    
    ObjExcel.DisplayAlerts = False
    Dim Path As String
    Path = App.Path & "\temp\temp" & Format(Date, "dd-mm-yyyy") & _
           "-" & Format(Time, "ss-mm-hh") & ".xls"
    Libro.SaveAs Path
    Libro.Close True
    Set Hoja = Nothing
    Set Libro = Nothing
    
    ObjExcel.Quit
    Set ObjExcel = Nothing
    
    rs.Close
    Set rs = Nothing
    ExportarExcel = Path
    Screen.MousePointer = vbNormal
End Function

