VERSION 5.00
Begin VB.Form frmADO 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Customer Form"
   ClientHeight    =   2820
   ClientLeft      =   1095
   ClientTop       =   1500
   ClientWidth     =   6720
   ControlBox      =   0   'False
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   10.5
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   2820
   ScaleWidth      =   6720
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox txtData 
      BackColor       =   &H8000000F&
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Index           =   0
      Left            =   1680
      Locked          =   -1  'True
      MaxLength       =   20
      TabIndex        =   22
      Top             =   60
      Width           =   840
   End
   Begin VB.PictureBox Picture1 
      Align           =   2  'Align Bottom
      Height          =   492
      Left            =   0
      ScaleHeight     =   435
      ScaleWidth      =   6660
      TabIndex        =   11
      Top             =   2325
      Width           =   6720
      Begin VB.CommandButton cmdLast 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   1320
         Picture         =   "ADO.frx":0000
         Style           =   1  'Graphical
         TabIndex        =   21
         ToolTipText     =   "Last row"
         Top             =   60
         UseMaskColor    =   -1  'True
         Width           =   372
      End
      Begin VB.CommandButton cmdFirst 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   60
         Picture         =   "ADO.frx":0102
         Style           =   1  'Graphical
         TabIndex        =   20
         ToolTipText     =   "First row"
         Top             =   60
         UseMaskColor    =   -1  'True
         Width           =   372
      End
      Begin VB.CommandButton cmdPrevious 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   480
         Picture         =   "ADO.frx":0204
         Style           =   1  'Graphical
         TabIndex        =   19
         ToolTipText     =   "Previous row"
         Top             =   60
         UseMaskColor    =   -1  'True
         Width           =   372
      End
      Begin VB.CommandButton cmdNext 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   900
         Picture         =   "ADO.frx":0306
         Style           =   1  'Graphical
         TabIndex        =   18
         ToolTipText     =   "Next row"
         Top             =   60
         UseMaskColor    =   -1  'True
         Width           =   372
      End
      Begin VB.CommandButton cmdCancel 
         Cancel          =   -1  'True
         Caption         =   "&Cancel"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   2580
         TabIndex        =   17
         Top             =   60
         Width           =   735
      End
      Begin VB.CommandButton cmdSave 
         Caption         =   "&Save"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   1800
         TabIndex        =   16
         Top             =   60
         Width           =   735
      End
      Begin VB.CommandButton cmdClose 
         Caption         =   "C&lose"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   5880
         TabIndex        =   15
         Top             =   60
         Width           =   735
      End
      Begin VB.CommandButton cmdDelete 
         Caption         =   "&Delete"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   5100
         TabIndex        =   14
         Top             =   60
         Width           =   735
      End
      Begin VB.CommandButton cmdNew 
         Caption         =   "&New"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   4320
         TabIndex        =   13
         Top             =   60
         Width           =   735
      End
      Begin VB.CommandButton cmdFind 
         Caption         =   "&Find"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   3540
         TabIndex        =   12
         Top             =   60
         Width           =   735
      End
   End
   Begin VB.TextBox txtData 
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Index           =   5
      Left            =   4920
      TabIndex        =   7
      Top             =   1320
      Width           =   1272
   End
   Begin VB.ComboBox cboState 
      DataField       =   "State"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      IntegralHeight  =   0   'False
      Left            =   4020
      Sorted          =   -1  'True
      Style           =   2  'Dropdown List
      TabIndex        =   6
      Top             =   1320
      Width           =   852
   End
   Begin VB.CheckBox chkActive 
      Alignment       =   1  'Right Justify
      Caption         =   "Active?"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Left            =   1680
      TabIndex        =   8
      Top             =   1800
      Width           =   1515
   End
   Begin VB.TextBox txtData 
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Index           =   4
      Left            =   1680
      MaxLength       =   25
      TabIndex        =   5
      Top             =   1320
      Width           =   2295
   End
   Begin VB.TextBox txtData 
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Index           =   3
      Left            =   1680
      LinkTimeout     =   35
      MaxLength       =   35
      TabIndex        =   3
      Top             =   900
      Width           =   4512
   End
   Begin VB.TextBox txtData 
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Index           =   2
      Left            =   3360
      MaxLength       =   25
      TabIndex        =   2
      Top             =   480
      Width           =   2832
   End
   Begin VB.TextBox txtData 
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Index           =   1
      Left            =   1680
      MaxLength       =   20
      TabIndex        =   1
      Top             =   480
      Width           =   1620
   End
   Begin VB.Label Label1 
      Caption         =   "Customer ID"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Left            =   120
      TabIndex        =   10
      Top             =   60
      Width           =   1455
   End
   Begin VB.Label lblCity 
      Caption         =   "City/State/Zip"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Left            =   120
      TabIndex        =   4
      Top             =   1320
      Width           =   1455
   End
   Begin VB.Label lblStreet 
      Caption         =   "Street"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Left            =   120
      TabIndex        =   9
      Top             =   900
      Width           =   1455
   End
   Begin VB.Label lblFirst 
      Caption         =   "Name"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Left            =   120
      TabIndex        =   0
      Top             =   480
      Width           =   1455
   End
End
Attribute VB_Name = "frmADO"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private customer As CustomerHandler

' This is the name of the field to use for searching.
Private Const conFindField = "LastName"

Private customerRecordset As ADODB.Recordset

' Constants indicating the current
' data state.
Private Enum DataState
    Loading = 0
    Adding = 1
    Editing = 2
    NoRows = 3
    Normal = 4
End Enum
Private currentDataState As DataState

Private Sub cmdCancel_Click()
    Call ShowData
End Sub

Private Sub cmdClose_Click()
    customer.CloseRecordset customerRecordset
    Unload Me
End Sub

Private Sub cmdDelete_Click()
    Call DeleteRow
End Sub

Private Sub cmdFind_Click()
    Call FindRow
End Sub

Private Sub cmdFirst_Click()
    customerRecordset.MoveFirst
    Call ShowData
End Sub

Private Sub cmdLast_Click()
    customerRecordset.MoveLast
    Call ShowData
End Sub

Private Sub cmdNew_Click()
    Call AddNewRow
End Sub

Private Sub cmdNext_Click()
    customerRecordset.MoveNext
    Call ShowData
End Sub

Private Sub cmdPrevious_Click()
    customerRecordset.MovePrevious
    Call ShowData
End Sub

Private Sub cmdSave_Click()
    Call SaveData
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    
    ' Add support for PageUp, PageDown,
    ' Ctrl+PageUp, Ctrl+PageDown,
    ' Ctrl+Home, Ctrl+End
    
    Select Case KeyCode
        Case vbKeyPageDown
            If Shift = vbCtrlMask Then
                Call cmdLast_Click
            Else
                If cmdNext.Enabled Then
                    Call cmdNext_Click
                End If
            End If
        Case vbKeyPageUp
            If Shift = vbCtrlMask Then
                Call cmdFirst_Click
            Else
                If cmdPrevious.Enabled Then
                    Call cmdPrevious_Click
                End If
            End If
        Case vbKeyHome
            If Shift = vbCtrlMask Then
                Call cmdFirst_Click
            End If
            ' "Eat" the keystroke.
            KeyCode = 0
        Case vbKeyEnd
            If Shift = vbCtrlMask Then
                Call cmdLast_Click
            End If
            ' "Eat" the keystroke.
            KeyCode = 0
    End Select
End Sub

Private Sub Form_Load()
    On Error GoTo ErrorHandler
    
    Set customer = New CustomerHandler
        
    ' Open the connection and the
    ' recordset, and then initialize
    ' the form.
    Set customerRecordset = customer.GetCustomers
    If Not customerRecordset Is Nothing Then
        Call InitForm
        
        ' Display the form.
        Call ShowData
    Else
        MsgBox "Unable to load the requested data."
        Unload Me
    End If
    
ExitHere:
    Exit Sub

ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError(Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Set customer = Nothing
End Sub

Private Sub ClearForm()
    ' Clear out all the controls.
    ' This form has only text boxes, check boxes,
    ' and combo boxes.
    
    ' Your forms may have other controls to worry about.
    
    ' Watch out for recursive events: setting the
    ' text of a textbox to "" will trigger its Change
    ' event, for example. That's why this code
    ' sets currentDataState to be Loading. No current
    ' code uses that particular state value, but
    ' it at least indicates that something's going on.
    
    Dim ctl As Control
    
    On Error GoTo ErrorHandler
    
    currentDataState = DataState.Loading
    
    For Each ctl In Me.Controls
        If TypeOf ctl Is TextBox Then
            ctl.Text = ""
        ElseIf TypeOf ctl Is CheckBox Then
            ctl.Value = vbChecked
        ElseIf TypeOf ctl Is ComboBox Then
            ctl.ListIndex = -1
        ' TODO:
        ' Add more control types, if necessary.
        End If
    Next ctl
    
    If customerRecordset.RecordCount = 0 Then
        currentDataState = DataState.NoRows
    Else
        currentDataState = DataState.Adding
    End If
    
ExitHere:
    Exit Sub

ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError(Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Sub DeleteRow()
    On Error GoTo ErrorHandler
    
    If MsgBox( _
     "Delete the current record?", _
     vbYesNo + vbQuestion, Me.Caption) = vbYes Then
        ' It appears that ADO loses the
        ' current row unless you resynch
        ' the bookmark before making the
        ' delete. Otherwise, after
        ' deleting and moving, you may
        ' be on the wrong row.
        customerRecordset.Bookmark = customerRecordset.Bookmark
        customerRecordset.Delete
        
        If customerRecordset.RecordCount > 0 Then
            ' Move off the deleted row. The deleted
            ' row is still current until you leave it.
            
            ' At this point, you know there are
            ' some rows, and you may or may not
            ' be at the end of file. If so, you
            ' need to move back one row.
            customerRecordset.MoveNext
            If customerRecordset.EOF Then
                customerRecordset.MovePrevious
            End If
        End If
        ' Whether there's any data or not,
        ' show a row.
        Call ShowData
    End If

ExitHere:
    Exit Sub

ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError(Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Function SaveData() As Boolean
    Dim currentBookmark As Variant
    Dim isOK As Boolean
    
    isOK = True
    
    ' Retrieving a bookmark would trigger an
    ' error if there are no rows, so just
    ' disregard the error. If there are no rows,
    ' currentBookmark will just contain Empty.
    On Error Resume Next
    currentBookmark = customerRecordset.Bookmark
    
    On Error GoTo ErrorHandler
    If currentDataState = DataState.Adding Then
        customerRecordset.AddNew
    End If
    
    ' Whether adding or editing,
    ' you need to save fields and update
    ' the recordset.
    Call SaveFields
    customerRecordset.Update
    
    If currentDataState = DataState.Adding Then
        ' Display the newly added key.
        Call GetID
    End If
    
    ' Reset Buttons
    currentDataState = DataState.Normal
    Call HandleButtonState
    
ExitHere:
    If Not isOK Then
        ' If something went wrong, then go back
        ' to the original row.
        If Not IsEmpty(currentBookmark) Then
            customerRecordset.Bookmark = currentBookmark
        End If
    End If
    SaveData = isOK
    Exit Function
    
ErrorHandler:
    isOK = False
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError(Err.Number, Err.Description)
    End Select
    Call GotoFirstControl
    Resume ExitHere
End Function

Private Sub HandleNavButtons()

    ' Handle the enabling/disabling of
    ' the navigation buttons.
    
    ' No point even considering errors that
    ' occur in here.
    On Error Resume Next
    
    Select Case currentDataState
        Case DataState.Adding, DataState.Editing
            cmdFirst.Enabled = False
            cmdPrevious.Enabled = False
            cmdNext.Enabled = False
            cmdLast.Enabled = False
        Case Else
            ' Move to the previous row,
            ' and see if you're
            ' at the beginning of the recordset.
            customerRecordset.MovePrevious
            cmdFirst.Enabled = Not customerRecordset.BOF
            cmdPrevious.Enabled = Not customerRecordset.BOF
            customerRecordset.MoveNext
            
            ' Move to the next row,
            ' and see if you're at the end.
            customerRecordset.MoveNext
            cmdNext.Enabled = Not customerRecordset.EOF
            cmdLast.Enabled = Not customerRecordset.EOF
            customerRecordset.MovePrevious
    End Select
End Sub

Private Sub FindRow()
    Dim searchCriteria As String
    Dim nameToFind As String
    Dim currentBookmark As Variant
    
    On Error GoTo ErrorHandler
    
    nameToFind = InputBox( _
     "Enter " & conFindField & " value to find:", _
     Me.Caption)
    
    If Len(nameToFind) > 0 Then
        
        searchCriteria = conFindField & " LIKE " & _
            AddQuotes(nameToFind & "%")
        
        ' Store away the bookmark, in
        ' case the find fails.
        currentBookmark = customerRecordset.Bookmark
        
        ' Find the record.
        customerRecordset.MoveFirst
        customerRecordset.Find searchCriteria
        
        If customerRecordset.EOF Then
            MsgBox "No match found!", vbOKOnly, Me.Caption
            
            ' Move back to the original row.
            customerRecordset.Bookmark = currentBookmark
        Else
            Call ShowData
        End If
    End If

ExitHere:
    Exit Sub
    
ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError( _
             Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Sub AddNewRow()
    ' Add a new row.
    
    ' Clear the form, and manage the navigation
    ' buttons. Set the focus to the
    ' correct text box.
    Call ClearForm
    Call HandleButtonState
    Call GotoFirstControl
End Sub

Private Sub HandleButtonState()
    Select Case currentDataState
        Case DataState.Adding, DataState.Editing
            cmdSave.Enabled = True
            cmdCancel.Enabled = True
            cmdFind.Enabled = False
            cmdNew.Enabled = False
            cmdDelete.Enabled = False
            cmdClose.Enabled = False
        Case DataState.NoRows
            cmdSave.Enabled = False
            cmdCancel.Enabled = False
            cmdFind.Enabled = False
            cmdNew.Enabled = False
            cmdDelete.Enabled = False
            cmdClose.Enabled = True
        Case Else
            cmdSave.Enabled = False
            cmdCancel.Enabled = False
            cmdFind.Enabled = True
            cmdNew.Enabled = True
            cmdDelete.Enabled = True
            cmdClose.Enabled = True
    End Select
    Call HandleNavButtons
End Sub

' Routines below here are specific to this form/data.

Private Sub InitForm()
    ' Put any code here that you want
    ' to run once for your form.
    
    On Error GoTo ErrorHandler
    
    ' Load the combo box with state values.
    Call LoadStates
    
ExitHere:
    Exit Sub
    
ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError( _
             Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Sub ShowData()
    
    On Error GoTo ErrorHandler
    
    ' Set this flag so event procedures
    ' don't do anything during this
    ' process.
    currentDataState = DataState.Loading
    
    If customerRecordset.RecordCount = 0 Then
        Call AddNewRow
    Else
        txtData(0).Text = NullToText(customerRecordset("CustomerID"))
        txtData(1).Text = NullToText(customerRecordset("FirstName"))
        txtData(2).Text = NullToText(customerRecordset("LastName"))
        txtData(3).Text = NullToText(customerRecordset("Address"))
        txtData(4).Text = NullToText(customerRecordset("City"))
        txtData(5).Text = NullToText(customerRecordset("ZipCode"))
        
        Call FindString(cboState, _
         NullToText(customerRecordset("State")))
        chkActive.Value = FixBoolean(customerRecordset("Active"))
    
        Call HandleButtonState
        currentDataState = DataState.Normal
    End If
    Call GotoFirstControl

ExitHere:
    Exit Sub
    
ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError( _
             Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Sub SaveFields()
    On Error GoTo ErrorHandler
    
    ' The ADO/Jet provider will not allow
    ' empty strings in fields that don't
    ' explicitly allow empty strings (as
    ' opposed to Nulls). Convert empty
    ' text boxes back to Null, for storage
    ' in the table.
    
    customerRecordset("FirstName") = TextToNull(txtData(1).Text)
    customerRecordset("LastName") = TextToNull(txtData(2).Text)
    customerRecordset("Address") = TextToNull(txtData(3).Text)
    customerRecordset("City") = TextToNull(txtData(4).Text)
    customerRecordset("ZipCode") = TextToNull(txtData(5).Text)
    
    customerRecordset("State") = TextToNull(cboState.Text)
    customerRecordset("Active") = CBool(chkActive.Value)

ExitHere:
    Exit Sub

ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError( _
             Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Sub GetID()
    ' Get the newly added customer ID.
    On Error GoTo ErrorHandler
        
    txtData(0).Text = customerRecordset("CustomerID")
     
ExitHere:
    Exit Sub
    
ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError( _
             Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Sub GotoFirstControl()
    ' Set the focus to the first control
    ' on your form. This procedure is
    ' separated out, because it requires
    ' knowledge of your particular form.
    On Error Resume Next
    txtData(1).SetFocus
End Sub

Private Sub LoadStates()
    ' Load cboStates from tblStates.
    Dim states As ADODB.Recordset
    Set states = customer.GetStates()
    
    Do Until states.EOF
        cboState.AddItem states("State")
        states.MoveNext
    Loop
    
ExitHere:
    If Not states Is Nothing Then
        states.Close
        Set states = Nothing
    End If
    Exit Sub
    
ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError( _
             Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Sub txtData_Change(Index As Integer)
    ' You typed into a text box.
    ' Check what to do at this point.
    Call HandleChange
End Sub

Private Sub cboState_Click()
    On Error GoTo ErrorHandler
    
    ' If there were no rows, now
    ' you're adding a new one.
    ' If you were in normal state,
    ' now you're editing.
    ' If you were editing, you still are.
    ' In any other state, you have no
    ' business being in here.
    Select Case currentDataState
        Case DataState.NoRows
            currentDataState = DataState.Adding
        Case DataState.Normal
            currentDataState = DataState.Editing
        Case DataState.Editing
            ' Do nothing.
        Case Else
            Exit Sub
    End Select
    
    ' If you're editing, check to
    ' see if the combo box value
    ' has changed from what's stored
    ' in the data.
    If currentDataState = DataState.Editing Then
        ' If there's no change, don't bother
        ' enabling buttons.
        If cboState.Text = _
         NullToText(customerRecordset("State")) Then
            Exit Sub
        End If
    End If
    Call HandleButtonState
    
ExitHere:
    Exit Sub

ErrorHandler:
    Select Case Err.Number
        Case Else
            Call HandleUnexpectedError( _
             Err.Number, Err.Description)
    End Select
    Resume ExitHere
End Sub

Private Sub chkActive_Click()
    Call HandleChange
End Sub

Private Sub HandleChange()
    ' Deal with changes to text
    ' boxes or check box.
    ' If there are no rows, now you're
    ' editing.
    ' If you're just viewing data,
    ' now you're editing.
    ' Otherwise, get out.
    Select Case currentDataState
        Case DataState.NoRows
            currentDataState = DataState.Adding
        Case DataState.Normal
            currentDataState = DataState.Editing
        Case Else
            Exit Sub
    End Select
    
    ' Set up the buttons.
    Call HandleButtonState
End Sub

