Attribute VB_Name = "basUtility"
Option Explicit

Public Sub HandleUnexpectedError(lngError As Long, strDescription As String)
    MsgBox "Error: " & strDescription & _
    " (" & lngError & ")"
End Sub

Public Function AddQuotes(strValue As String) As String
    ' If a string to be quoted contains
    ' an apostrophe, then simply replace
    ' it with two. VBA will see the two
    ' apostrophes as a single apostrophe,
    ' and all will be well.
    AddQuotes = _
     "'" & Replace(strValue, "'", "''") & "'"
End Function

Public Sub FindString( _
 ctl As Control, strFind As String)
    ' Find strFind in ctl, which must be either
    ' a list box or a combo box.
    On Error Resume Next
    
    ' Attempt to set the value of the control
    ' to be the specified text.
    ctl.Text = strFind
    If Err.Number <> 0 Then
        ctl.ListIndex = -1
    End If
End Sub

Public Function FixBoolean(fld As ADODB.Field) _
 As CheckBoxConstants
    ' Convert a Yes/No/Null field value
    ' into a checkbox value.
    
    If CBool(fld.Value) Then
        FixBoolean = vbChecked
    Else
        FixBoolean = vbUnchecked
    End If
End Function

Public Function NullToText(fld As ADODB.Field) _
 As String
    ' Append an empty string, forcing a conversion
    ' of a Null value to a string, leaving normal
    ' strings as is.
    NullToText = fld.Value & ""
    '
    ' Or, you can use:
    ' If IsNull(fld.Value) Then
    '     NullToText = ""
    ' Else
    '     NullToText = fld.Value
    ' End If
End Function

Public Function TextToNull(strValue As String) As Variant
    ' Convert a text string to Null, if
    ' the string has no characters. ADO appears
    ' to require this, at least with the Jet
    ' provider.
    If Len(strValue) = 0 Then
        TextToNull = Null
    Else
        TextToNull = strValue
    End If
End Function


