using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Nomad.Controls;

namespace TestApplication
{
  public partial class Form1 : Form
  {
    public Form1()
    {
      InitializeComponent();
      XPProgressBarRenderer CustomRenderer = new XPProgressBarRenderer(Color.Blue);
      CustomRenderer.MarqueeStyle = MarqueeStyle.LeftRight;
      barCustom.Renderer = CustomRenderer;
      
      cmbStyle.DataSource = Enum.GetValues(typeof(ProgressBarStyle));
    }

    private void cmbStyle_SelectedIndexChanged(object sender, EventArgs e)
    {
      ProgressBarStyle Style = (ProgressBarStyle)((ComboBox)sender).SelectedIndex;
    
      barSystem.Style = Style;
      barVistaNormal.Style = Style;
      barVistaPaused.Style = Style;
      barVistaError.Style = Style;
      barCustom.Style = Style;
    }

    private void nudValue_ValueChanged(object sender, EventArgs e)
    {
      barSystem.Value = (int)nudValue.Value;
      barVistaNormal.Value = (int)nudValue.Value;
      barVistaPaused.Value = (int)nudValue.Value;
      barVistaError.Value = (int)nudValue.Value;
      barCustom.Value = (int)nudValue.Value;
    }
  }
}