VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CFileInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' *********************************************************************
'  NUEZ SOFTWARES, All Rights Reserved
'  Esta aplicacion ha sido creada por
'  T.S.U en Informatica - Analista en Sistemas Miguel Nuez
' *********************************************************************
Option Explicit

Private Declare Function GetFullPathName Lib "kernel32" Alias "GetFullPathNameA" (ByVal lpFileName As String, ByVal nBufferLength As Long, ByVal lpBuffer As String, lpFilePart As Long) As Long
Private Declare Function GetShortPathName Lib "kernel32" Alias "GetShortPathNameA" (ByVal lpszLongPath As String, ByVal lpszShortPath As String, ByVal nBufferLength As Long) As Long
Private Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
Private Declare Function FileTimeToLocalFileTime Lib "kernel32" (lpFileTime As FILETIME, lpLocalFileTime As FILETIME) As Long
Private Declare Function FileTimeToSystemTime Lib "kernel32" (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME) As Long
Private Declare Function GetCompressedFileSize Lib "kernel32" Alias "GetCompressedFileSizeA" (ByVal lpFileName As String, lpFileSizeHigh As Long) As Long
Private Declare Function SHGetFileInfo Lib "shell32.dll" Alias "SHGetFileInfoA" (ByVal pszPath As String, ByVal dwFileAttributes As Long, psfi As SHFILEINFO, ByVal cbFileInfo As Long, ByVal uFlags As Long) As Long

Private Const MAX_PATH = 260
Private Const INVALID_HANDLE_VALUE = -1

Private Const FILE_ATTRIBUTE_READONLY = &H1
Private Const FILE_ATTRIBUTE_HIDDEN = &H2
Private Const FILE_ATTRIBUTE_SYSTEM = &H4
Private Const FILE_ATTRIBUTE_DIRECTORY = &H10
Private Const FILE_ATTRIBUTE_ARCHIVE = &H20
Private Const FILE_ATTRIBUTE_NORMAL = &H80
Private Const FILE_ATTRIBUTE_TEMPORARY = &H100
Private Const FILE_ATTRIBUTE_COMPRESSED = &H800

Private Const SHGFI_ICON = &H100
Private Const SHGFI_DISPLAYNAME = &H200
Private Const SHGFI_TYPENAME = &H400
Private Const SHGFI_ATTRIBUTES = &H800
Private Const SHGFI_ICONLOCATION = &H1000
Private Const SHGFI_EXETYPE = &H2000
Private Const SHGFI_SYSICONINDEX = &H4000
Private Const SHGFI_LINKOVERLAY = &H8000
Private Const SHGFI_SELECTED = &H10000
Private Const SHGFI_LARGEICON = &H0
Private Const SHGFI_SMALLICON = &H1
Private Const SHGFI_OPENICON = &H2
Private Const SHGFI_SHELLICONSIZE = &H4
Private Const SHGFI_PIDL = &H8
Private Const SHGFI_USEFILEATTRIBUTES = &H10

Private Type FILETIME
   dwLowDateTime As Long
   dwHighDateTime As Long
End Type

Private Type WIN32_FIND_DATA
   dwFileAttributes As Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As Long
   nFileSizeLow As Long
   dwReserved0 As Long
   dwReserved1 As Long
   cFileName As String * MAX_PATH
   cAlternate As String * 14
End Type

Private Type SYSTEMTIME
   wYear As Integer
   wMonth As Integer
   wDayOfWeek As Integer
   wDay As Integer
   wHour As Integer
   wMinute As Integer
   wSecond As Integer
   wMilliseconds As Integer
End Type

Private Type SHFILEINFO
   hIcon As Long
   iIcon As Long
   dwAttributes As Long
   szDisplayName As String * MAX_PATH
   szTypeName As String * 80
End Type

Private m_PathName As String
Private m_Name As String
Private m_Path As String
Private m_Extension As String
Private m_DisplayName As String
Private m_TypeName As String
Private m_hIcon As Long
Private m_PathNameShort As String
Private m_NameShort As String
Private m_PathShort As String
Private m_FileExists As Boolean
Private m_PathExists As Boolean
Private m_FileSize As Long
Private m_FileSizeHigh As Long
Private m_CompFileSize As Long
Private m_CompFileSizeHigh As Long
Private m_Attributes As Long
Private m_tmCreation As Double
Private m_tmAccess As Double
Private m_tmWrite As Double

Public Property Let FullPathName(ByVal NewVal As String)
   Dim Buffer As String
   Dim nFilePart As Long
   Dim nRet As Long

   Buffer = Space(MAX_PATH)
   nRet = GetFullPathName(NewVal, Len(Buffer), Buffer, nFilePart)
   If nRet Then
      m_PathName = Left(Buffer, nRet)
      Refresh
   End If
End Property

Public Property Get FullPathName() As String
   FullPathName = m_PathName
End Property

Public Property Get FileName() As String
   FileName = m_Name
End Property

Public Property Get FilePath() As String
   FilePath = m_Path
End Property

Public Property Get FileExtension() As String
   FileExtension = m_Extension
End Property

Public Property Get ShortPathName() As String
   ShortPathName = m_PathNameShort
End Property

Public Property Get ShortName() As String
   ShortName = m_NameShort
End Property

Public Property Get ShortPath() As String
   ShortPath = m_PathShort
End Property

Public Property Get DisplayName() As String
   DisplayName = m_DisplayName
End Property

Public Property Get TypeName() As String
   TypeName = m_TypeName
End Property

Public Property Get FileExists() As Boolean
   FileExists = m_FileExists
End Property

Public Property Get PathExists() As Boolean
   PathExists = m_PathExists
End Property

Public Property Get FileSize() As Long
   FileSize = m_FileSize
End Property

Public Property Get FileSizeHigh() As Long
   FileSizeHigh = m_FileSizeHigh
End Property

Public Property Get CompressedFileSize() As Long
   CompressedFileSize = m_CompFileSize
End Property

Public Property Get CompressedFileSizeHigh() As Long
   CompressedFileSizeHigh = m_CompFileSizeHigh
End Property

Public Property Get CreationTime() As Double
   CreationTime = m_tmCreation
End Property

Public Property Get LastAccessTime() As Double
   LastAccessTime = m_tmAccess
End Property

Public Property Get ModifyTime() As Double
   ModifyTime = m_tmWrite
End Property

Public Property Get Attributes() As Long
   Attributes = m_Attributes
End Property

Public Property Get attrReadOnly() As Boolean
   attrReadOnly = (m_Attributes And FILE_ATTRIBUTE_READONLY)
End Property

Public Property Get attrHidden() As Boolean
   attrHidden = (m_Attributes And FILE_ATTRIBUTE_HIDDEN)
End Property

Public Property Get attrSystem() As Boolean
   attrSystem = (m_Attributes And FILE_ATTRIBUTE_SYSTEM)
End Property

Public Property Get attrArchive() As Boolean
   attrArchive = (m_Attributes And FILE_ATTRIBUTE_ARCHIVE)
End Property

Public Property Get attrTemporary() As Boolean
   attrTemporary = (m_Attributes And FILE_ATTRIBUTE_TEMPORARY)
End Property

Public Property Get attrCompressed() As Boolean
   attrCompressed = (m_Attributes And FILE_ATTRIBUTE_COMPRESSED)
End Property

Public Property Get hIcon() As Long
   hIcon = m_hIcon
End Property
Public Sub Refresh()
   Dim hSearch As Long
   Dim wfd As WIN32_FIND_DATA
   Dim Buffer As String
   Dim nRet As Long
   Dim i As Long
   Dim sfi As SHFILEINFO
   
   hSearch = FindFirstFile(m_PathName, wfd)
   If hSearch <> INVALID_HANDLE_VALUE Then
      Call FindClose(hSearch)
      
      m_FileExists = True
      m_PathExists = True
      m_FileSize = wfd.nFileSizeLow
      m_FileSizeHigh = wfd.nFileSizeHigh
      m_Attributes = wfd.dwFileAttributes
      m_tmCreation = FileTimeToDouble(wfd.ftCreationTime, True)
      m_tmAccess = FileTimeToDouble(wfd.ftLastAccessTime, True)
      m_tmWrite = FileTimeToDouble(wfd.ftLastWriteTime, True)

      m_Name = TrimNull(wfd.cFileName)
      For i = Len(m_PathName) To 1 Step -1
         If Mid(m_PathName, i, 1) = "\" Then
            m_Path = ProperCasePath(Left(m_PathName, i))
            If Right(m_Path, 1) <> "\" Then m_Path = m_Path & "\"
            Exit For
         End If
      Next i
      m_PathName = m_Path & m_Name

      If InStr(m_Name, ".") Then
         For i = Len(m_Name) To 1 Step -1
            If Mid(m_Name, i, 1) = "." Then
               m_Extension = Mid(m_Name, i + 1)
               Exit For
            End If
         Next i
      Else
         m_Extension = ""
      End If
  
      If InStr(wfd.cAlternate, vbNullChar) = 1 Then
         m_NameShort = UCase(m_Name)
      Else
         m_NameShort = TrimNull(wfd.cAlternate)
      End If

      Buffer = Space(MAX_PATH)
      nRet = GetShortPathName(m_PathName, Buffer, Len(Buffer))
      If nRet Then
         m_PathNameShort = Left(Buffer, nRet)
         m_PathShort = Left(m_PathNameShort, Len(m_PathNameShort) - Len(m_NameShort))
      End If

      m_CompFileSize = GetCompressedFileSize(m_PathName, m_CompFileSizeHigh)

      nRet = SHGetFileInfo(m_PathName, 0&, sfi, Len(sfi), _
             SHGFI_ICON Or SHGFI_DISPLAYNAME Or SHGFI_TYPENAME)
      m_DisplayName = TrimNull(sfi.szDisplayName)
      m_TypeName = TrimNull(sfi.szTypeName)
      m_hIcon = sfi.hIcon
 
      If Trim(m_TypeName) = "" Then
         m_TypeName = Trim(UCase(m_Extension) & " File")
      End If
   Else
   
      m_FileExists = False
   End If
End Sub

Public Function FormatFileDate(ByVal dt As Double) As String
   FormatFileDate = Format(dt, "long date") & " " & _
                    Format(dt, "long time")
End Function

Public Function FormatFileSize(ByVal Size As Long) As String
   Dim sRet As String
   Const KB& = 1024
   Const MB& = KB * KB
   
   If Size < KB Then
      sRet = Format(Size, "#,##0") & " bytes"
   Else
      Select Case Size \ KB
         Case Is < 10
            sRet = Format(Size / KB, "0.00") & "KB"
         Case Is < 100
            sRet = Format(Size / KB, "0.0") & "KB"
         Case Is < 1000
            sRet = Format(Size / KB, "0") & "KB"
         Case Is < 10000
            sRet = Format(Size / MB, "0.00") & "MB"
         Case Is < 100000
            sRet = Format(Size / MB, "0.0") & "MB"
         Case Is < 1000000
            sRet = Format(Size / MB, "0") & "MB"
         Case Is < 10000000
            sRet = Format(Size / MB / KB, "0.00") & "GB"
      End Select
      sRet = sRet & " (" & Format(Size, "#,##0") & " bytes)"
   End If
   FormatFileSize = sRet
End Function


Private Function FileTimeToDouble(ftUTC As FILETIME, Localize As Boolean) As Double
   Dim ft As FILETIME
   Dim st As SYSTEMTIME
   Dim d As Double
   Dim t As Double
 
   If Localize Then
      Call FileTimeToLocalFileTime(ftUTC, ft)
   Else
      ft = ftUTC
   End If
 
   Call FileTimeToSystemTime(ft, st)
 
   FileTimeToDouble = DateSerial(st.wYear, st.wMonth, st.wDay) + _
                      TimeSerial(st.wHour, st.wMinute, st.wSecond)
End Function

Private Function ProperCasePath(ByVal PathIn As String) As String
   Dim hSearch As Long
   Dim wfd As WIN32_FIND_DATA
   Dim PathOut As String
   Dim i As Long
 
   If Right(PathIn, 1) = "\" Then
      If Right(PathIn, 2) <> ":\" Then
         PathIn = Left(PathIn, Len(PathIn) - 1)
      Else
         ProperCasePath = UCase(PathIn)
         Exit Function
      End If
   End If
  
   If InStr(PathIn, "\\") = 1 Then
      i = InStr(3, PathIn, "\")
      If i > 0 Then
         If InStr(i + 1, PathIn, "\") = 0 Then
            ProperCasePath = PathIn
            Exit Function
         End If
      End If
   End If
  
   If InStr(PathIn, "\") Then
      For i = Len(PathIn) To 1 Step -1
         If Mid(PathIn, i, 1) = "\" Then
   
            PathOut = ProperCasePath(Left(PathIn, i - 1)) & "\"
  
            hSearch = FindFirstFile(PathIn, wfd)
            If hSearch <> INVALID_HANDLE_VALUE Then
               Call FindClose(hSearch)
               If wfd.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY Then
                  ProperCasePath = PathOut & TrimNull(wfd.cFileName)
               End If
            End If
  
            Exit For
         End If
      Next i
   Else
  
      ProperCasePath = UCase(PathIn)
   End If
End Function

Private Function TrimNull(ByVal StrIn As String) As String
   Dim nul As Long
  
   nul = InStr(StrIn, vbNullChar)
   Select Case nul
      Case Is > 1
         TrimNull = Left(StrIn, nul - 1)
      Case 1
         TrimNull = ""
      Case 0
         TrimNull = Trim(StrIn)
   End Select
End Function

