Attribute VB_Name = "Module1"
 Option Explicit

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' El ejemplo para poder enviar el mail necesita la referencia a: _
  > Miscrosoft CDO Windows For 2000 Library ( es el archivo dll cdosys.dll )

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Function Enviar_Mail_CDO(SerVidor_SMTP As String, _
                             Para As String, _
                             De As String, _
                             Asunto As String, _
                             Mensaje As String, _
                             Optional Path_Adjunto As String, _
                             Optional Puerto As String = "25", _
                             Optional Usuario As String, _
                             Optional Password As String, _
                             Optional Usar_Autentificacion As Boolean = True, _
                             Optional Usar_SSL As Boolean = True) As Boolean
    
    
    Screen.MousePointer = vbHourglass
    
    ' Variable de objeto Cdo.Message
    Dim Obj_Email As CDO.Message
          
    
    ' Crea un Nuevo objeto CDO.Message
    Set Obj_Email = New CDO.Message
    
    ' Indica el servidor Smtp para poder enviar el Mail ( puede ser el nombre _
      del servidor o su direccin IP )
    Obj_Email.Configuration.Fields(cdoSMTPServer) = SerVidor_SMTP
    
    Obj_Email.Configuration.Fields(cdoSendUsingMethod) = 2
    
    ' Puerto. Por defecto se usa el puerto 25, en el caso de Gmail se usan los puertos _
      465 o  el puerto 587 ( este ltimo me dio error )
    If Puerto = "" Then Puerto = "25"
    Obj_Email.Configuration.Fields.Item _
        ("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = CLng(Puerto)

    
    ' Indica el tipo de autentificacin con el servidor de correo _
     El valor 0 no requiere autentificarse, el valor 1 es con autentificacin
    Obj_Email.Configuration.Fields.Item("http://schemas.microsoft.com/cdo/" & _
                "configuration/smtpauthenticate") = Abs(Usar_Autentificacion)
    
    
    
        ' Tiempo mximo de espera en segundos para la conexin
    Obj_Email.Configuration.Fields.Item _
        ("http://schemas.microsoft.com/cdo/configuration/smtpconnectiontimeout") = 30

    
    ' Configura las opciones para el login en el SMTP
    If Usar_Autentificacion Then

    ' Id de usuario del servidor Smtp ( en el caso de gmail, debe ser la direccin de correro _
     mas el @gmail.com )
    Obj_Email.Configuration.Fields.Item _
        ("http://schemas.microsoft.com/cdo/configuration/sendusername") = Usuario

    ' Password de la cuenta
    Obj_Email.Configuration.Fields.Item _
        ("http://schemas.microsoft.com/cdo/configuration/sendpassword") = Password

    ' Indica si se usa SSL para el envo. En el caso de Gmail requiere que est en True
    Obj_Email.Configuration.Fields.Item _
        ("http://schemas.microsoft.com/cdo/configuration/smtpusessl") = Usar_SSL
    
    End If
    

    ' *********************************************************************************
    ' Estructura del mail
    '**********************************************************************************
    
    ' Direccin del Destinatario
    Obj_Email.To = Para
    
    ' Direccin del remitente
    Obj_Email.From = De
    
    ' Asunto del mensaje
    Obj_Email.Subject = Asunto
    
    ' Cuerpo del mensaje
    Obj_Email.TextBody = Mensaje
    
    'Ruta del archivo adjunto
    
    If Path_Adjunto <> vbNullString Then
        Obj_Email.AddAttachment (Path_Adjunto)
    End If
    
    ' Actualiza los datos antes de enviar
    Obj_Email.Configuration.Fields.Update
    
    On Error Resume Next
    ' Enva el email
    Obj_Email.Send
    
    
    If Err.Number = 0 Then
       Enviar_Mail_CDO = True
    Else
       MsgBox Err.Description, vbCritical, " Error al enviar el amil "
    End If
    
    ' Descarga la referencia
    If Not Obj_Email Is Nothing Then
        Set Obj_Email = Nothing
    End If
    
    On Error GoTo 0
    Screen.MousePointer = vbNormal

End Function



