Option Explicit On

Imports System.Windows.Forms
Imports System.Diagnostics
Imports Rss
Imports Microsoft.VisualBasic

Public Class frmRss

    Private css_Estilo As String

    Private Sub Form1_Load( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles MyBase.Load

        ' css para el H1,a , hover , body etc..
        css_Estilo = "<html><head>" & vbNewLine & _
                     "<style type=" & Chr(34) & "text/css" & Chr(34) & ">" & vbNewLine & _
                     "h1 {" & vbNewLine & _
                     "font-family: Geneva, Arial, Helvetica, sans-serif; font-size: " & _
                     "22px;font-weight: bold;color: #76a5f3; }" & vbNewLine & _
                     "hr {" & vbNewLine & _
                     "color: #999999;border: thin dotted;}" & vbNewLine & _
                     "a:hover {" & vbNewLine & _
                     "color: #FF9900;font-family: Verdana, Arial, Helvetica, sans-serif;}" & vbNewLine & _
                     "a {" & vbNewLine & _
                     "color: #76a5f3;font-family: Verdana, Arial, Helvetica, sans-serif;}" & vbNewLine & _
                     "body {" & vbNewLine & _
                     "font-family: Geneva, Arial, Helvetica, sans-serif; font-size: " & _
                     "12px;color: #666666; }" & vbNewLine & _
                     "</style></head>"


        'MsgBox(css_Estilo)

        ' carga algunas urls
        With cbo_URL.Items
            .Add("http://d.yimg.com/ar.rss.news.yahoo.com/rss/titulares")
            .Add("http://news.google.com.ar/nwshp?oe=UTF-8&hl=es&tab=wn&q=&output=rss")
        End With
    End Sub

    ' leer el feed
    ' '''''''''''''''''''''''''''''''''''''''''''
    Private Sub Leer_feed(ByVal Url As String)
        ' cursor de espera
        Me.Cursor = System.Windows.Forms.Cursors.WaitCursor

        Try
            ' lee la url y lo enlaza al combo
            ' ''''''''''''''''''''''''''''''''''''''''''
            Dim feed As RssFeed = RssFeed.Read(Url)

            Dim channel As RssChannel = feed.Channels(0)

            With cboTitulos

                .DataSource = channel.Items
                ' ttulo
                Me.Text = channel.Title.ToString
                gBoxContent.Text = channel.Title.ToString
            End With

            ' errores
        Catch oMessage As Exception
            MsgBox(oMessage.Message, MsgBoxStyle.Critical)
        End Try
        ' restaura el cursor
        Me.Cursor = System.Windows.Forms.Cursors.Default
    End Sub

    ' cambio de ttulo
    Private Sub cboTitulos_SelectedIndexChanged_1( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) _
            Handles cboTitulos.SelectedIndexChanged

        Try
            Dim item As RssItem = cboTitulos.SelectedItem

            'TextBox1.Text = item.Description.ToString
            Dim sContenido As String

            With wb
                ' Etiqueta para el encabezado ( H1) y una lnea (HR)
                sContenido = "<h1>" & item.Title & "</h1><hr>"
                ' Contenido / Descripcin
                sContenido = sContenido & "<p>" & item.Description.ToString
                ' Agrega una linea
                sContenido = sContenido & "<p><hr noshade>"
                ' link al final
                sContenido = sContenido & "<b>Direccin Url</b><p>" & item.Link.AbsoluteUri.ToString

                ' cierra el body/html y le pasa el contenido a la propiedad DocumentText 
                ' del(WebBrowser) para crear el documento
                .DocumentText = css_Estilo & "<body>" & sContenido & "</body></html>"
            End With

            ' LinkLabel para el URI
            With LinkLabel1
                .Links.Clear()
                .Text = item.Title ' texto a mostrar ( ttulo del item actual)
                .LinkBehavior = LinkBehavior.HoverUnderline ' subrayado

                ' aade el enlace
                .Links.Add(0, item.Title.Length, item.Link.AbsoluteUri.ToString)
            End With

            ' detalles del feed
            With item
                ' El autor
                If .Author.ToString = "" Then
                    lblAuthor.Text = "> Author: no establecido"
                Else
                    lblAuthor.Text = "> Autor: " & .Author.ToString
                End If
                'lblComentarios.Text = .Comments.ToString
                'lblQuery.Text = "Query: " & .Link.Query.ToString

                ' fecha de publicacin, el host , ..otros
                lblPub.Text = "> Fecha de publicacin: " & .PubDate.ToString
                lblHost.Text = "> Host: " & .Link.Host.ToString
                lblLocalPath.Text = "> Path rel : " & .Link.LocalPath.ToString
                lblCountFeeds.Text = "Cantidad de titles: " & _
                                     cboTitulos.Items.Count.ToString - 1
            End With

            lblActualfeed.Text = cboTitulos.SelectedIndex.ToString & _
                                 "/" & cboTitulos.Items.Count - 1
            ' errores
        Catch oMsg As Exception
            MsgBox(oMsg.Message, MsgBoxStyle.Critical, _
                  "error en cboTitulos_SelectedIndexChanged")
        End Try
    End Sub

    ' descargar el formulario
    Private Sub SalirToolStripMenuItem_Click( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) _
            Handles SalirToolStripMenuItem.Click
        Me.Close()
    End Sub

    ' abre una nueva instancia del formulario
    Private Sub NuevaVentanaToolStripMenuItem_Click( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) _
            Handles NuevaVentanaToolStripMenuItem.Click

        Dim frmNewRss As New frmRss
        frmNewRss.Show()
    End Sub

    ' combo de URLs
    Private Sub cbo_URL_KeyUp( _
        ByVal sender As Object, _
        ByVal e As System.Windows.Forms.KeyEventArgs) _
            Handles cbo_URL.KeyUp

        cmdLoadFeed.Enabled = CBool(cbo_URL.Text.Length)
    End Sub

    ' combo de URLs
    Private Sub cbo_URL_SelectedIndexChanged( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) _
        Handles cbo_URL.SelectedIndexChanged
        ' habilita o deshabilita el botn
        cmdLoadFeed.Enabled = CBool(cbo_URL.Text.Length)

    End Sub

    ' cambia el SelectedIndex del combo ttulos
    Sub Cambiar_Feed(ByVal Op As Integer)

        With cboTitulos
            Select Case Op
                ' siguiente item
                Case 0
                    If .SelectedIndex > 0 Then
                        .SelectedIndex = .SelectedIndex - 1
                    End If
                    ' anterior item
                Case 1

                    If .SelectedIndex < (.Items.Count - 1) Then
                        .SelectedIndex = .SelectedIndex + 1
                    End If
                Case Else
                    '.SelectedIndex = Op
            End Select
        End With
    End Sub

    ' botn Siguiente
    Private Sub cmdNext_Click( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles cmdNext.Click

        Cambiar_Feed(1)

    End Sub

    ' botn anterior
    Private Sub cmdPrev_Click( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) _
            Handles cmdPrev.Click
        Cambiar_Feed(0)
    End Sub

    ' abre el navegador predeterminado y carga la pgina al clickear el LinkLabel
    Private Sub LinkLabel1_LinkClicked( _
        ByVal sender As Object, _
        ByVal e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) _
            Handles LinkLabel1.LinkClicked

        With LinkLabel1
            Process.Start(e.Link.LinkData)
        End With
    End Sub

    Private Sub cmdLoadFeed_Click( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles cmdLoadFeed.Click

        ' Le pasa la direccin para cargar el feed
        Call Leer_feed(cbo_URL.Text)

    End Sub
End Class
