Option Explicit On
Option Strict On

' para usar la clase StreamWriter
Imports System
Imports System.IO

Public Class Form1

    ' botn para recorrer el datagridView y guardarlo en el archivo
    Private Sub Button1_Click( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) _
        Handles Button1.Click

        Const DELIMITADOR As String = ";"

        ' ruta del fichero de texto
        Const ARCHIVO_CSV As String = "c:\archivo.txt"

        Try
            'Nuevo objeto StreamWriter, para acceder al fichero y poder guardar las lneas
            Using archivo As StreamWriter = New StreamWriter(ARCHIVO_CSV)

                ' variable para almacenar la lnea actual del dataview
                Dim linea As String = String.Empty

                With DataGridView1
                    ' Recorrer las filas del dataGridView
                    For fila As Integer = 0 To .RowCount - 1
                        ' vaciar la lnea
                        linea = String.Empty

                        ' Recorrer la cantidad de columnas que contiene el dataGridView
                        For col As Integer = 0 To .Columns.Count - 1
                            ' Almacenar el valor de toda la fila , y cada campo separado por el delimitador
                            linea = linea & .Item(col, fila).Value.ToString & DELIMITADOR
                        Next

                        ' Escribir una lnea con el mtodo WriteLine
                        With archivo
                            ' eliminar el ltimo caracter ";" de la cadena
                            linea = linea.Remove(linea.Length - 1).ToString
                            ' escribir la fila
                            .WriteLine(linea.ToString)
                        End With
                    Next
                End With
            End Using

            ' Abrir con Process.Start el archivo de texto
            Process.Start(ARCHIVO_CSV)

            'error
        Catch ex As Exception
            MsgBox(ex.Message.ToString, MsgBoxStyle.Critical)
        End Try
    End Sub

    Private Sub Form1_Load( _
        ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles MyBase.Load

        Button1.Text = "Guardar en csv"

        With DataGridView1
            ' agregar cuatro columnas al control DataGridView
            For iHeader As Integer = 0 To 3
                .Columns.Add("Columna " & iHeader.ToString, _
                             "Columna " & iHeader.ToString)
            Next

            ' Indicar a la propiedad RowCount la cantidad de filas a establecer
            .RowCount = 20

            ' Recorrer toda las filas
            For fila As Integer = 0 To .Rows.Count - 1
                ' recorrer todas las columnas
                For col As Integer = 0 To .Columns.Count - 1
                    ' Aadir algunos datos en cada celda
                    .Item(col, fila).Value = "Fila: " & fila & " Columna " & col
                Next
            Next
        End With
    End Sub
End Class
